/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.ksn.testcontainers;

import java.util.HashMap;
import java.util.Map;

public class KsnClusterConfig {
    private String imageName = "streamnative/sn-pulsar:3.1.0.4";
    private int numBookies = 2;
    private int numBrokers = 2;
    final Map<String, String> configs = new HashMap<String, String>();

    public KsnClusterConfig setImageName(String imageName) {
        this.imageName = imageName;
        return this;
    }

    public String getImageName() {
        return this.imageName;
    }

    public KsnClusterConfig setNumBookies(int numBookies) {
        if (numBookies < 2) {
            throw new IllegalArgumentException("numBookies must be greater than 1");
        }
        this.numBookies = numBookies;
        return this;
    }

    public int getNumBookies() {
        return this.numBookies;
    }

    public KsnClusterConfig setNumBrokers(int numBrokers) {
        if (numBrokers < 1) {
            throw new IllegalArgumentException("numBrokers must be positive");
        }
        this.numBrokers = numBrokers;
        return this;
    }

    public int getNumBrokers() {
        return this.numBrokers;
    }

    public KsnClusterConfig addConfig(String key, String value) {
        this.configs.put(key, value);
        return this;
    }
}

