/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.ksn.testcontainers;

import io.streamnative.ksn.testcontainers.BrokerContainer;
import io.streamnative.ksn.testcontainers.KsnClusterConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class KsnCluster
implements AutoCloseable {
    private static final String ZK_HOST = "zookeeper";
    private static final int ZK_PORT = 2181;
    private static final String CLUSTER = "ksn-cluster";
    private final Network network = Network.newNetwork();
    private final GenericContainer<?> zkContainer;
    private final List<GenericContainer<?>> bookies;
    private final List<BrokerContainer> brokers;
    private final String bootstrapServers;

    public KsnCluster() throws IOException, InterruptedException {
        this(new KsnClusterConfig());
    }

    public KsnCluster(KsnClusterConfig config) throws IOException, InterruptedException {
        DockerImageName imageName = DockerImageName.parse((String)config.getImageName());
        this.zkContainer = new GenericContainer(imageName).withNetwork(this.network).withNetworkAliases(new String[]{ZK_HOST}).withEnv("PULSAR_MEM", "-Xmx256M").withCommand("bin/pulsar zookeeper").withExposedPorts(new Integer[]{2181});
        this.zkContainer.start();
        String metadataStoreUrl = "zk:zookeeper:2181";
        Container.ExecResult result = this.zkContainer.execInContainer(new String[]{"/pulsar/bin/pulsar", "initialize-cluster-metadata", "--cluster", CLUSTER, "--metadata-store", "zk:zookeeper:2181", "--configuration-metadata-store", "zk:zookeeper:2181", "--web-service-url", "http://broker-:8080", "--broker-service-url", "pulsar://broker-:6650"});
        if (result.getExitCode() != 0) {
            throw new IOException("Failed to initialize metadata");
        }
        this.bookies = new ArrayList(config.getNumBookies());
        for (int i = 0; i < config.getNumBookies(); ++i) {
            String host = "bookie-" + i;
            GenericContainer bookie = new GenericContainer(imageName).withCopyFileToContainer(MountableFile.forClasspathResource((String)"run-bookie.sh"), "/pulsar/bin/run-bookie.sh").withNetwork(this.network).withNetworkAliases(new String[]{host}).withCreateContainerCmdModifier(cmd -> cmd.withHostName(host)).withEnv("BOOKIE_MEM", "-Xmx512M").withEnv("useHostNameAsBookieID", "true").withEnv("zkServers", "zookeeper:2181").withEnv("autoRecoveryDaemonEnabled", "false").withCommand("bash bin/run-bookie.sh").withExposedPorts(new Integer[]{3181});
            bookie.start();
            this.bookies.add(bookie);
        }
        this.brokers = new ArrayList<BrokerContainer>(config.getNumBrokers());
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < config.getNumBrokers(); ++i) {
            BrokerContainer broker = new BrokerContainer(imageName, this.network, "zk:zookeeper:2181", CLUSTER, config.configs);
            broker.start();
            this.brokers.add(broker);
            if (i > 0) {
                builder.append(",");
            }
            builder.append(broker.getHost()).append(":").append(broker.getPort());
        }
        this.bootstrapServers = builder.toString();
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public String getPulsarWebServiceUrl() {
        return "http://localhost:" + this.brokers.get(0).getMappedPort(8080);
    }

    @Override
    public void close() {
        if (this.brokers != null) {
            this.brokers.forEach(Startable::close);
        }
        if (this.bookies != null) {
            this.bookies.forEach(Startable::close);
        }
        if (this.zkContainer != null) {
            this.zkContainer.close();
        }
        this.network.close();
    }
}

