/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.tools;

import java.io.IOException;
import org.apache.pulsar.kafka.shade.avro.Schema;
import org.apache.pulsar.kafka.shade.io.confluent.common.utils.AbstractPerformanceTest;
import org.apache.pulsar.kafka.shade.io.confluent.common.utils.PerformanceStats;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.avro.AvroCompatibilityLevel;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.client.rest.RestService;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;

public class SchemaRegistryClientPerformance
extends AbstractPerformanceTest {
    long targetRegisteredSchemas;
    long targetSchemasPerSec;
    String baseUrl;
    RestService restService;
    String subject;
    long registeredSchemas = 0L;
    long successfullyRegisteredSchemas = 0L;
    CachedSchemaRegistryClient client;

    public static void main(String[] args) throws Exception {
        if (args.length < 4) {
            System.out.println("Usage: java " + SchemaRegistryClientPerformance.class.getName() + " schema_registry_url subject num_schemas target_schemas_per_sec");
            System.exit(1);
        }
        String baseUrl = args[0];
        String subject = args[1];
        int numSchemas = Integer.parseInt(args[2]);
        int targetSchemasPerSec = Integer.parseInt(args[3]);
        SchemaRegistryClientPerformance perf = new SchemaRegistryClientPerformance(baseUrl, subject, numSchemas, targetSchemasPerSec);
        perf.run(targetSchemasPerSec);
        perf.close();
    }

    public SchemaRegistryClientPerformance(String baseUrl, String subject, long numSchemas, long targetSchemasPerSec) throws Exception {
        super(numSchemas);
        this.baseUrl = baseUrl;
        this.restService = new RestService(baseUrl);
        this.subject = subject;
        this.targetRegisteredSchemas = numSchemas;
        this.targetSchemasPerSec = targetSchemasPerSec;
        this.client = new CachedSchemaRegistryClient(this.restService, Integer.MAX_VALUE);
        this.client.updateCompatibility(null, AvroCompatibilityLevel.NONE.name);
    }

    private static Schema makeSchema(long num) {
        String schemaString = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f" + num + "\"}]}";
        Schema.Parser parser1 = new Schema.Parser();
        Schema schema = parser1.parse(schemaString);
        return schema;
    }

    @Override
    protected void doIteration(PerformanceStats.Callback cb) {
        Schema schema = SchemaRegistryClientPerformance.makeSchema(this.registeredSchemas);
        try {
            this.client.register(this.subject, schema);
            int id = this.client.getId(this.subject, schema);
            int version = this.client.getVersion(this.subject, schema);
            ++this.successfullyRegisteredSchemas;
        }
        catch (IOException e) {
            System.out.println("Problem registering schema: " + e.getMessage());
        }
        catch (RestClientException e) {
            System.out.println("Problem registering schema: " + e.getMessage());
        }
        ++this.registeredSchemas;
        cb.onCompletion(1, 0L);
    }

    protected void close() {
        if ((double)this.successfullyRegisteredSchemas / (double)this.targetRegisteredSchemas < 0.99) {
            throw new RuntimeException("Too many schema registration errors: " + this.successfullyRegisteredSchemas + " registered successfully out of " + this.targetRegisteredSchemas + " attempted");
        }
    }

    @Override
    protected boolean finished(int iteration) {
        return this.targetRegisteredSchemas == this.registeredSchemas;
    }

    @Override
    protected boolean runningFast(int iteration, float elapsed) {
        return (float)iteration / elapsed > (float)this.targetSchemasPerSec;
    }
}

