/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.kafka.shade.io.confluent.kafka.serializers;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.pulsar.kafka.shade.avro.Schema;
import org.apache.pulsar.kafka.shade.avro.generic.GenericContainer;

public class AvroSchemaUtils {
    private static final Map<String, Schema> primitiveSchemas;

    private static Schema createPrimitiveSchema(Schema.Parser parser, String type) {
        String schemaString = String.format("{\"type\" : \"%s\"}", type);
        return parser.parse(schemaString);
    }

    protected static Schema copyOf(Schema schema) {
        return new Schema.Parser().parse(schema.toString());
    }

    protected static Map<String, Schema> getPrimitiveSchemas() {
        return Collections.unmodifiableMap(primitiveSchemas);
    }

    public static Schema getSchema(Object object) {
        if (object == null) {
            return primitiveSchemas.get("Null");
        }
        if (object instanceof Boolean) {
            return primitiveSchemas.get("Boolean");
        }
        if (object instanceof Integer) {
            return primitiveSchemas.get("Integer");
        }
        if (object instanceof Long) {
            return primitiveSchemas.get("Long");
        }
        if (object instanceof Float) {
            return primitiveSchemas.get("Float");
        }
        if (object instanceof Double) {
            return primitiveSchemas.get("Double");
        }
        if (object instanceof CharSequence) {
            return primitiveSchemas.get("String");
        }
        if (object instanceof byte[]) {
            return primitiveSchemas.get("Bytes");
        }
        if (object instanceof GenericContainer) {
            return ((GenericContainer)object).getSchema();
        }
        throw new IllegalArgumentException("Unsupported Avro type. Supported types are null, Boolean, Integer, Long, Float, Double, String, byte[] and IndexedRecord");
    }

    static {
        Schema.Parser parser = new Schema.Parser();
        primitiveSchemas = new HashMap<String, Schema>();
        primitiveSchemas.put("Null", AvroSchemaUtils.createPrimitiveSchema(parser, "null"));
        primitiveSchemas.put("Boolean", AvroSchemaUtils.createPrimitiveSchema(parser, "boolean"));
        primitiveSchemas.put("Integer", AvroSchemaUtils.createPrimitiveSchema(parser, "int"));
        primitiveSchemas.put("Long", AvroSchemaUtils.createPrimitiveSchema(parser, "long"));
        primitiveSchemas.put("Float", AvroSchemaUtils.createPrimitiveSchema(parser, "float"));
        primitiveSchemas.put("Double", AvroSchemaUtils.createPrimitiveSchema(parser, "double"));
        primitiveSchemas.put("String", AvroSchemaUtils.createPrimitiveSchema(parser, "string"));
        primitiveSchemas.put("Bytes", AvroSchemaUtils.createPrimitiveSchema(parser, "bytes"));
    }
}

