/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.kafka.shade.io.confluent.kafka.serializers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import kafka.utils.VerifiableProperties;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.pulsar.kafka.shade.avro.Schema;
import org.apache.pulsar.kafka.shade.avro.generic.GenericDatumWriter;
import org.apache.pulsar.kafka.shade.avro.io.BinaryEncoder;
import org.apache.pulsar.kafka.shade.avro.io.EncoderFactory;
import org.apache.pulsar.kafka.shade.avro.specific.SpecificDatumWriter;
import org.apache.pulsar.kafka.shade.avro.specific.SpecificRecord;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.serializers.AbstractKafkaAvroSerDe;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.serializers.AvroSchemaUtils;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.serializers.KafkaAvroSerializerConfig;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.serializers.NonRecordContainer;

public abstract class AbstractKafkaAvroSerializer
extends AbstractKafkaAvroSerDe {
    private final EncoderFactory encoderFactory = EncoderFactory.get();
    protected boolean autoRegisterSchema;

    protected void configure(KafkaAvroSerializerConfig config) {
        this.configureClientProperties(config);
        this.autoRegisterSchema = config.autoRegisterSchema();
    }

    protected KafkaAvroSerializerConfig serializerConfig(Map<String, ?> props) {
        return new KafkaAvroSerializerConfig(props);
    }

    protected KafkaAvroSerializerConfig serializerConfig(VerifiableProperties props) {
        return new KafkaAvroSerializerConfig(props.props());
    }

    protected byte[] serializeImpl(String subject, Object object) throws SerializationException {
        Schema schema = null;
        if (object == null) {
            return null;
        }
        String restClientErrorMsg = "";
        try {
            int id;
            schema = AvroSchemaUtils.getSchema(object);
            if (this.autoRegisterSchema) {
                restClientErrorMsg = "Error registering Avro schema: ";
                id = this.schemaRegistry.register(subject, schema);
            } else {
                restClientErrorMsg = "Error retrieving Avro schema: ";
                id = this.schemaRegistry.getId(subject, schema);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(0);
            out.write(ByteBuffer.allocate(4).putInt(id).array());
            if (object instanceof byte[]) {
                out.write((byte[])object);
            } else {
                BinaryEncoder encoder = this.encoderFactory.directBinaryEncoder(out, null);
                Object value = object instanceof NonRecordContainer ? ((NonRecordContainer)object).getValue() : object;
                GenericDatumWriter writer = value instanceof SpecificRecord ? new SpecificDatumWriter(schema) : new GenericDatumWriter(schema);
                writer.write(value, encoder);
                encoder.flush();
            }
            byte[] bytes = out.toByteArray();
            out.close();
            return bytes;
        }
        catch (IOException | RuntimeException e) {
            throw new SerializationException("Error serializing Avro message", (Throwable)e);
        }
        catch (RestClientException e) {
            throw new SerializationException(restClientErrorMsg + schema, (Throwable)e);
        }
    }
}

