/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.kafka.shade.io.confluent.kafka.formatter;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kafka.common.MessageFormatter;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.pulsar.kafka.shade.avro.AvroRuntimeException;
import org.apache.pulsar.kafka.shade.avro.Schema;
import org.apache.pulsar.kafka.shade.avro.generic.GenericDatumWriter;
import org.apache.pulsar.kafka.shade.avro.io.EncoderFactory;
import org.apache.pulsar.kafka.shade.avro.io.JsonEncoder;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.serializers.AbstractKafkaAvroDeserializer;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.serializers.AvroSchemaUtils;

public class AvroMessageFormatter
extends AbstractKafkaAvroDeserializer
implements MessageFormatter {
    private final EncoderFactory encoderFactory = EncoderFactory.get();
    private static final byte[] NULL_BYTES = "null".getBytes(StandardCharsets.UTF_8);
    private boolean printKey = false;
    private boolean printIds = false;
    private boolean printKeyId = false;
    private boolean printValueId = false;
    private byte[] keySeparator = "\t".getBytes(StandardCharsets.UTF_8);
    private byte[] lineSeparator = "\n".getBytes(StandardCharsets.UTF_8);
    private byte[] idSeparator = "\t".getBytes(StandardCharsets.UTF_8);
    private Deserializer keyDeserializer;

    public AvroMessageFormatter() {
    }

    AvroMessageFormatter(SchemaRegistryClient schemaRegistryClient, Deserializer keyDeserializer) {
        this.schemaRegistry = schemaRegistryClient;
        this.keyDeserializer = keyDeserializer;
    }

    public void init(Properties props) {
        if (props == null) {
            throw new ConfigException("Missing schema registry url!");
        }
        String url = props.getProperty("schema.registry.url");
        if (url == null) {
            throw new ConfigException("Missing schema registry url!");
        }
        Map<String, Object> originals = this.getPropertiesMap(props);
        this.schemaRegistry = this.createSchemaRegistry(url, originals);
        if (props.containsKey("print.key")) {
            this.printKey = props.getProperty("print.key").trim().toLowerCase().equals("true");
        }
        if (props.containsKey("key.separator")) {
            this.keySeparator = props.getProperty("key.separator").getBytes(StandardCharsets.UTF_8);
        }
        if (props.containsKey("line.separator")) {
            this.lineSeparator = props.getProperty("line.separator").getBytes(StandardCharsets.UTF_8);
        }
        if (props.containsKey("key.deserializer")) {
            try {
                this.keyDeserializer = (Deserializer)Class.forName((String)props.get("key.deserializer")).newInstance();
            }
            catch (Exception e) {
                throw new ConfigException("Error initializing Key deserializer", (Object)e);
            }
        }
        if (props.containsKey("print.schema.ids")) {
            this.printIds = props.getProperty("print.schema.ids").trim().toLowerCase().equals("true");
            if (this.printIds) {
                this.printValueId = true;
                if (this.keyDeserializer == null || this.keyDeserializer instanceof AbstractKafkaAvroDeserializer) {
                    this.printKeyId = true;
                }
            }
        }
        if (props.containsKey("schema.id.separator")) {
            this.idSeparator = props.getProperty("schema.id.separator").getBytes(StandardCharsets.UTF_8);
        }
    }

    private Map<String, Object> getPropertiesMap(Properties props) {
        HashMap<String, Object> originals = new HashMap<String, Object>();
        for (String name : props.stringPropertyNames()) {
            originals.put(name, props.getProperty(name));
        }
        return originals;
    }

    public void writeTo(ConsumerRecord<byte[], byte[]> consumerRecord, PrintStream output) {
        if (this.printKey) {
            try {
                if (this.keyDeserializer != null) {
                    Object deserializedKey = consumerRecord.key() == null ? null : this.keyDeserializer.deserialize(null, (byte[])consumerRecord.key());
                    output.write(deserializedKey != null ? deserializedKey.toString().getBytes(StandardCharsets.UTF_8) : NULL_BYTES);
                } else {
                    this.writeTo((byte[])consumerRecord.key(), output);
                }
                if (this.printKeyId) {
                    output.write(this.idSeparator);
                    int schemaId = this.schemaIdFor((byte[])consumerRecord.key());
                    output.print(schemaId);
                }
                output.write(this.keySeparator);
            }
            catch (IOException ioe) {
                throw new SerializationException("Error while formatting the key", (Throwable)ioe);
            }
        }
        try {
            this.writeTo((byte[])consumerRecord.value(), output);
            if (this.printValueId) {
                output.write(this.idSeparator);
                int schemaId = this.schemaIdFor((byte[])consumerRecord.value());
                output.print(schemaId);
            }
            output.write(this.lineSeparator);
        }
        catch (IOException ioe) {
            throw new SerializationException("Error while formatting the value", (Throwable)ioe);
        }
    }

    private void writeTo(byte[] data, PrintStream output) throws IOException {
        Object object = this.deserialize(data);
        Schema schema = AvroSchemaUtils.getSchema(object);
        try {
            JsonEncoder encoder = this.encoderFactory.jsonEncoder(schema, output);
            GenericDatumWriter<Object> writer = new GenericDatumWriter<Object>(schema);
            if (object instanceof byte[]) {
                writer.write(ByteBuffer.wrap((byte[])object), encoder);
            } else {
                writer.write(object, encoder);
            }
            encoder.flush();
        }
        catch (AvroRuntimeException e) {
            throw new SerializationException(String.format("Error serializing Avro data of schema %s to json", schema), (Throwable)e);
        }
    }

    public void close() {
    }

    private int schemaIdFor(byte[] payload) {
        ByteBuffer buffer = ByteBuffer.wrap(payload);
        if (buffer.get() != 0) {
            throw new SerializationException("Unknown magic byte!");
        }
        return buffer.getInt();
    }

    private SchemaRegistryClient createSchemaRegistry(String schemaRegistryUrl, Map<String, Object> originals) {
        return this.schemaRegistry != null ? this.schemaRegistry : new CachedSchemaRegistryClient(schemaRegistryUrl, 1000, originals);
    }
}

