/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.kafka.shade.avro.file;

import java.util.HashMap;
import java.util.Map;
import org.apache.pulsar.kafka.shade.avro.AvroRuntimeException;
import org.apache.pulsar.kafka.shade.avro.file.BZip2Codec;
import org.apache.pulsar.kafka.shade.avro.file.Codec;
import org.apache.pulsar.kafka.shade.avro.file.DeflateCodec;
import org.apache.pulsar.kafka.shade.avro.file.NullCodec;
import org.apache.pulsar.kafka.shade.avro.file.SnappyCodec;
import org.apache.pulsar.kafka.shade.avro.file.XZCodec;

public abstract class CodecFactory {
    private static final Map<String, CodecFactory> REGISTERED = new HashMap<String, CodecFactory>();
    public static final int DEFAULT_DEFLATE_LEVEL = -1;
    public static final int DEFAULT_XZ_LEVEL = 6;

    public static CodecFactory nullCodec() {
        return NullCodec.OPTION;
    }

    public static CodecFactory deflateCodec(int compressionLevel) {
        return new DeflateCodec.Option(compressionLevel);
    }

    public static CodecFactory xzCodec(int compressionLevel) {
        return new XZCodec.Option(compressionLevel);
    }

    public static CodecFactory snappyCodec() {
        return new SnappyCodec.Option();
    }

    public static CodecFactory bzip2Codec() {
        return new BZip2Codec.Option();
    }

    protected abstract Codec createInstance();

    public static CodecFactory fromString(String s) {
        CodecFactory o = REGISTERED.get(s);
        if (o == null) {
            throw new AvroRuntimeException("Unrecognized codec: " + s);
        }
        return o;
    }

    public static CodecFactory addCodec(String name, CodecFactory c) {
        return REGISTERED.put(name, c);
    }

    public String toString() {
        Codec instance = this.createInstance();
        return instance.toString();
    }

    static {
        CodecFactory.addCodec("null", CodecFactory.nullCodec());
        CodecFactory.addCodec("deflate", CodecFactory.deflateCodec(-1));
        CodecFactory.addCodec("snappy", CodecFactory.snappyCodec());
        CodecFactory.addCodec("bzip2", CodecFactory.bzip2Codec());
        CodecFactory.addCodec("xz", CodecFactory.xzCodec(6));
    }
}

