/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.client.security.basicauth;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.security.JaasContext;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.client.security.basicauth.BasicAuthCredentialProvider;

public class SaslBasicAuthCredentialProvider
implements BasicAuthCredentialProvider {
    private String userInfo;

    @Override
    public String alias() {
        return "SASL_INHERIT";
    }

    public void configure(Map<String, ?> configs) {
        Map<String, Object> updatedConfigs = this.getConfigsForJaasUtil(configs);
        JaasContext jaasContext = JaasContext.loadClientContext(updatedConfigs);
        List appConfigurationEntries = jaasContext.configurationEntries();
        if (appConfigurationEntries != null && !appConfigurationEntries.isEmpty()) {
            Map<String, ?> options = ((AppConfigurationEntry)appConfigurationEntries.get(0)).getOptions();
            StringBuilder userInfoBuilder = new StringBuilder();
            if (options.containsKey("username")) {
                userInfoBuilder.append(options.get("username")).append(":").append(options.get("password"));
                this.userInfo = userInfoBuilder.toString();
            }
        }
        if (this.userInfo == null || this.userInfo.isEmpty()) {
            throw new ConfigException("Provided SASL Login module doesn't provide username and password options and can't be inherited");
        }
    }

    Map<String, Object> getConfigsForJaasUtil(Map<String, ?> configs) {
        Object saslJaasConfig;
        HashMap<String, Object> updatedConfigs = new HashMap<String, Object>(configs);
        if (updatedConfigs.containsKey("sasl.jaas.config") && (saslJaasConfig = updatedConfigs.get("sasl.jaas.config")) instanceof String) {
            updatedConfigs.put("sasl.jaas.config", new Password((String)saslJaasConfig));
        }
        return updatedConfigs;
    }

    @Override
    public String getUserInfo(URL url) {
        return this.userInfo;
    }
}

