/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.kafka.shade.io.confluent.kafka.serializers.subject;

import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.ParsedSchema;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.avro.AvroSchema;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy;

public class RecordNameStrategy
implements SubjectNameStrategy,
org.apache.pulsar.kafka.shade.io.confluent.kafka.serializers.subject.SubjectNameStrategy {
    public void configure(Map<String, ?> config) {
    }

    @Override
    public boolean usesSchema() {
        return true;
    }

    @Override
    public String subjectName(String topic, boolean isKey, ParsedSchema schema) {
        if (schema == null) {
            return null;
        }
        return this.getRecordName(schema, isKey);
    }

    protected String getRecordName(ParsedSchema schema, boolean isKey) {
        String name = schema.name();
        if (name != null) {
            return name;
        }
        if (isKey) {
            throw new SerializationException("In configuration key.subject.name.strategy = " + this.getClass().getName() + ", the message key must only be a record schema");
        }
        throw new SerializationException("In configuration value.subject.name.strategy = " + this.getClass().getName() + ", the message value must only be a record schema");
    }

    @Override
    @Deprecated
    public String getSubjectName(String topic, boolean isKey, Object value) {
        return this.subjectName(topic, isKey, new AvroSchema(AvroSchemaUtils.getSchema(value)));
    }
}

