/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.kafka.shade.io.confluent.kafka.serializers;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.pulsar.kafka.shade.avro.Schema;
import org.apache.pulsar.kafka.shade.avro.generic.GenericContainer;
import org.apache.pulsar.kafka.shade.avro.generic.GenericData;
import org.apache.pulsar.kafka.shade.avro.generic.GenericDatumReader;
import org.apache.pulsar.kafka.shade.avro.io.DatumReader;
import org.apache.pulsar.kafka.shade.avro.io.DecoderFactory;
import org.apache.pulsar.kafka.shade.avro.reflect.ReflectData;
import org.apache.pulsar.kafka.shade.avro.reflect.ReflectDatumReader;
import org.apache.pulsar.kafka.shade.avro.specific.SpecificData;
import org.apache.pulsar.kafka.shade.avro.specific.SpecificDatumReader;
import org.apache.pulsar.kafka.shade.avro.specific.SpecificRecord;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.avro.AvroSchema;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.serializers.AvroData;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.serializers.GenericContainerWithVersion;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.serializers.KafkaAvroDeserializerConfig;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.serializers.NonRecordContainer;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.serializers.SchemaPair;

public abstract class AbstractKafkaAvroDeserializer
extends AbstractKafkaSchemaSerDe {
    private final DecoderFactory decoderFactory = DecoderFactory.get();
    protected boolean useSpecificAvroReader = false;
    protected boolean avroReflectionAllowNull = false;
    protected boolean avroUseLogicalTypeConverters = false;
    protected boolean normalizeSchema = false;
    private final Map<String, Schema> readerSchemaCache = new ConcurrentHashMap<String, Schema>();
    private final Map<SchemaPair, DatumReader<?>> datumReaderCache = new ConcurrentHashMap();

    protected void configure(KafkaAvroDeserializerConfig config) {
        this.configureClientProperties(config, new AvroSchemaProvider());
        this.useSpecificAvroReader = config.getBoolean("specific.avro.reader");
        this.avroReflectionAllowNull = config.getBoolean("avro.reflection.allow.null");
        this.avroUseLogicalTypeConverters = config.getBoolean("avro.use.logical.type.converters");
        this.normalizeSchema = config.normalizeSchema();
    }

    protected KafkaAvroDeserializerConfig deserializerConfig(Map<String, ?> props) {
        return new KafkaAvroDeserializerConfig(props);
    }

    protected KafkaAvroDeserializerConfig deserializerConfig(Properties props) {
        return new KafkaAvroDeserializerConfig(props);
    }

    protected Object deserialize(byte[] payload) throws SerializationException {
        return this.deserialize(null, null, payload, null);
    }

    protected Object deserialize(byte[] payload, Schema readerSchema) throws SerializationException {
        return this.deserialize(null, null, payload, readerSchema);
    }

    protected Object deserialize(String topic, Boolean isKey, byte[] payload, Schema readerSchema) throws SerializationException {
        if (this.schemaRegistry == null) {
            throw new InvalidConfigurationException("SchemaRegistryClient not found. You need to configure the deserializer or use deserializer constructor with SchemaRegistryClient.");
        }
        if (payload == null) {
            return null;
        }
        DeserializationContext context = new DeserializationContext(topic, isKey, payload);
        return context.read(context.schemaFromRegistry().rawSchema(), readerSchema);
    }

    private Integer schemaVersion(String topic, Boolean isKey, int id, String subject, AvroSchema schema, Object result) throws IOException, RestClientException {
        Integer version;
        if (this.isDeprecatedSubjectNameStrategy(isKey)) {
            subject = this.getSubjectName(topic, isKey, result, schema);
            AvroSchema subjectSchema = (AvroSchema)this.schemaRegistry.getSchemaBySubjectAndId(subject, id);
            version = this.schemaRegistry.getVersion(subject, subjectSchema, this.normalizeSchema);
        } else {
            version = this.schemaRegistry.getVersion(subject, schema, this.normalizeSchema);
        }
        return version;
    }

    private String subjectName(String topic, Boolean isKey, AvroSchema schemaFromRegistry) {
        return this.isDeprecatedSubjectNameStrategy(isKey) ? null : this.getSubjectName(topic, isKey, null, schemaFromRegistry);
    }

    protected GenericContainerWithVersion deserializeWithSchemaAndVersion(String topic, boolean isKey, byte[] payload) throws SerializationException, InvalidConfigurationException {
        if (payload == null) {
            return null;
        }
        DeserializationContext context = new DeserializationContext(topic, isKey, payload);
        AvroSchema schema = context.schemaForDeserialize();
        Object result = context.read(schema.rawSchema(), null);
        try {
            Integer version = this.schemaVersion(topic, isKey, context.getSchemaId(), context.getSubject(), schema, result);
            if (schema.rawSchema().getType().equals((Object)Schema.Type.RECORD)) {
                return new GenericContainerWithVersion((GenericContainer)result, version);
            }
            return new GenericContainerWithVersion(new NonRecordContainer(schema.rawSchema(), result), version);
        }
        catch (IOException e) {
            throw new SerializationException("Error retrieving Avro " + AbstractKafkaAvroDeserializer.getSchemaType(isKey) + " schema version for id " + context.getSchemaId(), (Throwable)e);
        }
        catch (RestClientException e) {
            String errorMessage = "Error retrieving Avro " + AbstractKafkaAvroDeserializer.getSchemaType(isKey) + " schema version for id " + context.getSchemaId();
            throw AbstractKafkaAvroDeserializer.toKafkaException(e, errorMessage);
        }
    }

    protected DatumReader<?> getDatumReader(Schema writerSchema, Schema readerSchema) {
        Schema finalReaderSchema = this.getReaderSchema(writerSchema, readerSchema);
        SchemaPair cacheKey = new SchemaPair(writerSchema, finalReaderSchema);
        return this.datumReaderCache.computeIfAbsent(cacheKey, schema -> {
            boolean writerSchemaIsPrimitive = AvroSchemaUtils.getPrimitiveSchemas().values().contains(writerSchema);
            if (writerSchemaIsPrimitive) {
                GenericData genericData = new GenericData();
                if (this.avroUseLogicalTypeConverters) {
                    AvroData.addLogicalTypeConversion(genericData);
                }
                return new GenericDatumReader(writerSchema, finalReaderSchema, genericData);
            }
            if (this.useSchemaReflection) {
                return new ReflectDatumReader(writerSchema, finalReaderSchema);
            }
            if (this.useSpecificAvroReader) {
                return new SpecificDatumReader(writerSchema, finalReaderSchema);
            }
            GenericData genericData = new GenericData();
            if (this.avroUseLogicalTypeConverters) {
                AvroData.addLogicalTypeConversion(genericData);
            }
            return new GenericDatumReader(writerSchema, finalReaderSchema, genericData);
        });
    }

    private Schema getReaderSchema(Schema writerSchema, Schema readerSchema) {
        if (readerSchema != null) {
            return readerSchema;
        }
        boolean shouldSkipReaderSchemaCacheUsage = this.shouldSkipReaderSchemaCacheUsage(writerSchema);
        if (!shouldSkipReaderSchemaCacheUsage) {
            readerSchema = this.readerSchemaCache.get(writerSchema.getFullName());
        }
        if (readerSchema != null) {
            return readerSchema;
        }
        boolean writerSchemaIsPrimitive = AvroSchemaUtils.getPrimitiveSchemas().values().contains(writerSchema);
        if (writerSchemaIsPrimitive) {
            readerSchema = writerSchema;
        } else if (this.useSchemaReflection) {
            readerSchema = this.getReflectionReaderSchema(writerSchema);
            this.readerSchemaCache.put(writerSchema.getFullName(), readerSchema);
        } else if (this.useSpecificAvroReader) {
            readerSchema = this.getSpecificReaderSchema(writerSchema);
            if (!shouldSkipReaderSchemaCacheUsage) {
                this.readerSchemaCache.put(writerSchema.getFullName(), readerSchema);
            }
        } else {
            readerSchema = writerSchema;
        }
        return readerSchema;
    }

    private boolean shouldSkipReaderSchemaCacheUsage(Schema schema) {
        return this.useSpecificAvroReader && (schema.getType() == Schema.Type.ARRAY || schema.getType() == Schema.Type.MAP || schema.getType() == Schema.Type.UNION);
    }

    private Schema getSpecificReaderSchema(Schema writerSchema) {
        if (writerSchema.getType() == Schema.Type.ARRAY || writerSchema.getType() == Schema.Type.MAP || writerSchema.getType() == Schema.Type.UNION) {
            return writerSchema;
        }
        Class readerClass = SpecificData.get().getClass(writerSchema);
        if (readerClass == null) {
            throw new SerializationException("Could not find class " + writerSchema.getFullName() + " specified in writer's schema whilst finding reader's schema for a SpecificRecord.");
        }
        try {
            return ((SpecificRecord)readerClass.newInstance()).getSchema();
        }
        catch (InstantiationException e) {
            throw new SerializationException(writerSchema.getFullName() + " specified by the writers schema could not be instantiated to find the readers schema.");
        }
        catch (IllegalAccessException e) {
            throw new SerializationException(writerSchema.getFullName() + " specified by the writers schema is not allowed to be instantiated to find the readers schema.");
        }
    }

    private Schema getReflectionReaderSchema(Schema writerSchema) {
        ReflectData reflectData = this.avroReflectionAllowNull ? ReflectData.AllowNull.get() : ReflectData.get();
        Class readerClass = reflectData.getClass(writerSchema);
        if (readerClass == null) {
            throw new SerializationException("Could not find class " + writerSchema.getFullName() + " specified in writer's schema whilst finding reader's schema for a reflected class.");
        }
        return reflectData.getSchema(readerClass);
    }

    private static String getSchemaType(Boolean isKey) {
        if (isKey == null) {
            return "unknown";
        }
        if (isKey.booleanValue()) {
            return "key";
        }
        return "value";
    }

    class DeserializationContext {
        private final String topic;
        private final Boolean isKey;
        private final ByteBuffer buffer;
        private final int schemaId;

        DeserializationContext(String topic, Boolean isKey, byte[] payload) {
            this.topic = topic;
            this.isKey = isKey;
            this.buffer = AbstractKafkaAvroDeserializer.this.getByteBuffer(payload);
            this.schemaId = this.buffer.getInt();
        }

        AvroSchema schemaFromRegistry() {
            try {
                String subjectName = this.isKey == null || AbstractKafkaAvroDeserializer.this.strategyUsesSchema(this.isKey) ? this.getContext() : this.getSubject();
                return (AvroSchema)AbstractKafkaAvroDeserializer.this.schemaRegistry.getSchemaBySubjectAndId(subjectName, this.schemaId);
            }
            catch (IOException e) {
                throw new SerializationException("Error retrieving Avro " + AbstractKafkaAvroDeserializer.getSchemaType(this.isKey) + " schema for id " + this.schemaId, (Throwable)e);
            }
            catch (RestClientException e) {
                String errorMessage = "Error retrieving Avro " + AbstractKafkaAvroDeserializer.getSchemaType(this.isKey) + " schema for id " + this.schemaId;
                throw AbstractKafkaSchemaSerDe.toKafkaException(e, errorMessage);
            }
        }

        AvroSchema schemaForDeserialize() {
            try {
                return AbstractKafkaAvroDeserializer.this.isDeprecatedSubjectNameStrategy(this.isKey) ? AvroSchemaUtils.copyOf(this.schemaFromRegistry()) : (AvroSchema)AbstractKafkaAvroDeserializer.this.schemaRegistry.getSchemaBySubjectAndId(this.getSubject(), this.schemaId);
            }
            catch (IOException e) {
                throw new SerializationException("Error retrieving Avro " + AbstractKafkaAvroDeserializer.getSchemaType(this.isKey) + " schema for id " + this.schemaId, (Throwable)e);
            }
            catch (RestClientException e) {
                String errorMessage = "Error retrieving Avro " + AbstractKafkaAvroDeserializer.getSchemaType(this.isKey) + " schema for id " + this.schemaId;
                throw AbstractKafkaSchemaSerDe.toKafkaException(e, errorMessage);
            }
        }

        String getSubject() {
            boolean usesSchema = this.isKey != null && AbstractKafkaAvroDeserializer.this.strategyUsesSchema(this.isKey);
            return AbstractKafkaAvroDeserializer.this.subjectName(this.topic, this.isKey, usesSchema ? this.schemaFromRegistry() : null);
        }

        String getContext() {
            return AbstractKafkaAvroDeserializer.this.getContextName(this.topic);
        }

        String getTopic() {
            return this.topic;
        }

        boolean isKey() {
            return this.isKey;
        }

        int getSchemaId() {
            return this.schemaId;
        }

        Object read(Schema writerSchema) {
            return this.read(writerSchema, null);
        }

        Object read(Schema writerSchema, Schema readerSchema) {
            DatumReader<?> reader = AbstractKafkaAvroDeserializer.this.getDatumReader(writerSchema, readerSchema);
            int length = this.buffer.limit() - 1 - 4;
            if (writerSchema.getType().equals((Object)Schema.Type.BYTES)) {
                byte[] bytes = new byte[length];
                this.buffer.get(bytes, 0, length);
                return bytes;
            }
            int start = this.buffer.position() + this.buffer.arrayOffset();
            try {
                Object result = reader.read(null, AbstractKafkaAvroDeserializer.this.decoderFactory.binaryDecoder(this.buffer.array(), start, length, null));
                if (writerSchema.getType().equals((Object)Schema.Type.STRING)) {
                    return result.toString();
                }
                return result;
            }
            catch (IOException | RuntimeException e) {
                throw new SerializationException("Error deserializing Avro message for id " + this.schemaId, (Throwable)e);
            }
        }
    }
}

