/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.avro;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.AbstractSchemaProvider;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.ParsedSchema;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.avro.AvroSchema;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSchemaProvider
extends AbstractSchemaProvider {
    private static final Logger log = LoggerFactory.getLogger(AvroSchemaProvider.class);
    public static final String AVRO_VALIDATE_DEFAULTS = "avro.validate.defaults";
    private boolean validateDefaults = false;

    @Override
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
        String validate = (String)configs.get(AVRO_VALIDATE_DEFAULTS);
        this.validateDefaults = Boolean.parseBoolean(validate);
    }

    @Override
    public String schemaType() {
        return "AVRO";
    }

    @Override
    public Optional<ParsedSchema> parseSchema(String schemaString, List<SchemaReference> references, boolean isNew) {
        try {
            return Optional.of(new AvroSchema(schemaString, references, this.resolveReferences(references), null, this.validateDefaults && isNew));
        }
        catch (Exception e) {
            log.error("Could not parse Avro schema", (Throwable)e);
            return Optional.empty();
        }
    }
}

