/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.kafka.shade.io.confluent.kafka.serializers;

import java.util.Map;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.avro.AvroSchema;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.serializers.AbstractKafkaAvroSerializer;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.serializers.KafkaAvroSerializerConfig;

public class KafkaAvroSerializer
extends AbstractKafkaAvroSerializer
implements Serializer<Object> {
    private boolean isKey;

    public KafkaAvroSerializer() {
    }

    public KafkaAvroSerializer(SchemaRegistryClient client) {
        this.schemaRegistry = client;
    }

    public KafkaAvroSerializer(SchemaRegistryClient client, Map<String, ?> props) {
        this.schemaRegistry = client;
        this.configure(this.serializerConfig(props));
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.isKey = isKey;
        this.configure(new KafkaAvroSerializerConfig(configs));
    }

    public byte[] serialize(String topic, Object record) {
        if (record == null) {
            return null;
        }
        AvroSchema schema = new AvroSchema(AvroSchemaUtils.getSchema(record, this.useSchemaReflection, this.avroReflectionAllowNull, this.removeJavaProperties));
        return this.serializeImpl(this.getSubjectName(topic, this.isKey, record, schema), record, schema);
    }

    public void close() {
    }
}

