/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.kafka.shade.io.confluent.kafka.serializers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.pulsar.kafka.shade.avro.Schema;
import org.apache.pulsar.kafka.shade.avro.generic.GenericData;
import org.apache.pulsar.kafka.shade.avro.generic.GenericDatumWriter;
import org.apache.pulsar.kafka.shade.avro.io.BinaryEncoder;
import org.apache.pulsar.kafka.shade.avro.io.DatumWriter;
import org.apache.pulsar.kafka.shade.avro.io.EncoderFactory;
import org.apache.pulsar.kafka.shade.avro.reflect.ReflectDatumWriter;
import org.apache.pulsar.kafka.shade.avro.specific.SpecificDatumWriter;
import org.apache.pulsar.kafka.shade.avro.specific.SpecificRecord;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.avro.AvroSchema;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.serializers.AvroData;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.serializers.KafkaAvroSerializerConfig;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.serializers.NonRecordContainer;

public abstract class AbstractKafkaAvroSerializer
extends AbstractKafkaSchemaSerDe {
    private final EncoderFactory encoderFactory = EncoderFactory.get();
    protected boolean normalizeSchema;
    protected boolean autoRegisterSchema;
    protected boolean removeJavaProperties;
    protected int useSchemaId = -1;
    protected boolean idCompatStrict;
    protected boolean useLatestVersion;
    protected boolean latestCompatStrict;
    protected boolean avroReflectionAllowNull = false;
    protected boolean avroUseLogicalTypeConverters = false;
    private final Map<Schema, DatumWriter<Object>> datumWriterCache = new ConcurrentHashMap<Schema, DatumWriter<Object>>();

    protected void configure(KafkaAvroSerializerConfig config) {
        this.configureClientProperties(config, new AvroSchemaProvider());
        this.normalizeSchema = config.normalizeSchema();
        this.autoRegisterSchema = config.autoRegisterSchema();
        this.removeJavaProperties = config.getBoolean("avro.remove.java.properties");
        this.useSchemaId = config.useSchemaId();
        this.idCompatStrict = config.getIdCompatibilityStrict();
        this.useLatestVersion = config.useLatestVersion();
        this.latestCompatStrict = config.getLatestCompatibilityStrict();
        this.avroReflectionAllowNull = config.getBoolean("avro.reflection.allow.null");
        this.avroUseLogicalTypeConverters = config.getBoolean("avro.use.logical.type.converters");
    }

    protected KafkaAvroSerializerConfig serializerConfig(Map<String, ?> props) {
        return new KafkaAvroSerializerConfig(props);
    }

    protected KafkaAvroSerializerConfig serializerConfig(Properties props) {
        return new KafkaAvroSerializerConfig(props);
    }

    protected DatumWriter<?> getDatumWriter(Object value, Schema schema) {
        if (value instanceof SpecificRecord) {
            return new SpecificDatumWriter(schema);
        }
        if (this.useSchemaReflection) {
            return new ReflectDatumWriter(schema);
        }
        GenericData genericData = new GenericData();
        if (this.avroUseLogicalTypeConverters) {
            AvroData.addLogicalTypeConversion(genericData);
        }
        return new GenericDatumWriter(schema, genericData);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] serializeImpl(String subject, Object object, AvroSchema schema) throws SerializationException, InvalidConfigurationException {
        if (this.schemaRegistry == null) {
            StringBuilder userFriendlyMsgBuilder = new StringBuilder();
            userFriendlyMsgBuilder.append("You must configure() before serialize()");
            userFriendlyMsgBuilder.append(" or use serializer constructor with SchemaRegistryClient");
            throw new InvalidConfigurationException(userFriendlyMsgBuilder.toString());
        }
        if (object == null) {
            return null;
        }
        String restClientErrorMsg = "";
        try {
            int id;
            if (this.autoRegisterSchema) {
                restClientErrorMsg = "Error registering Avro schema";
                id = this.schemaRegistry.register(subject, schema, this.normalizeSchema);
            } else if (this.useSchemaId >= 0) {
                restClientErrorMsg = "Error retrieving schema ID";
                schema = (AvroSchema)this.lookupSchemaBySubjectAndId(subject, this.useSchemaId, schema, this.idCompatStrict);
                id = this.schemaRegistry.getId(subject, schema);
            } else if (this.useLatestVersion) {
                restClientErrorMsg = "Error retrieving latest version of Avro schema";
                schema = (AvroSchema)this.lookupLatestVersion(subject, schema, this.latestCompatStrict);
                id = this.schemaRegistry.getId(subject, schema, this.normalizeSchema);
            } else {
                restClientErrorMsg = "Error retrieving Avro schema";
                id = this.schemaRegistry.getId(subject, schema, this.normalizeSchema);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(0);
            out.write(ByteBuffer.allocate(4).putInt(id).array());
            Object value = object instanceof NonRecordContainer ? ((NonRecordContainer)object).getValue() : object;
            Schema rawSchema = schema.rawSchema();
            if (rawSchema.getType().equals((Object)Schema.Type.BYTES)) {
                if (value instanceof byte[]) {
                    out.write((byte[])value);
                } else {
                    if (!(value instanceof ByteBuffer)) throw new SerializationException("Unrecognized bytes object of type: " + value.getClass().getName());
                    out.write(((ByteBuffer)value).array());
                }
            } else {
                this.writeDatum(out, value, rawSchema);
            }
            byte[] bytes = out.toByteArray();
            out.close();
            return bytes;
        }
        catch (IOException | RuntimeException e) {
            throw new SerializationException("Error serializing Avro message", (Throwable)e);
        }
        catch (RestClientException e) {
            throw AbstractKafkaAvroSerializer.toKafkaException(e, restClientErrorMsg + schema);
        }
    }

    private void writeDatum(ByteArrayOutputStream out, Object value, Schema rawSchema) throws IOException {
        BinaryEncoder encoder = this.encoderFactory.directBinaryEncoder(out, null);
        DatumWriter writer = this.datumWriterCache.computeIfAbsent(rawSchema, v -> this.getDatumWriter(value, rawSchema));
        writer.write(value, encoder);
        encoder.flush();
    }
}

