/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.ParsedSchema;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.SchemaValidationStrategy;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.SchemaValidator;

public final class SchemaValidatorBuilder {
    private SchemaValidationStrategy strategy;

    public SchemaValidatorBuilder canReadStrategy() {
        this.strategy = (toValidate, existing) -> toValidate.isBackwardCompatible(existing);
        return this;
    }

    public SchemaValidatorBuilder canBeReadStrategy() {
        this.strategy = (toValidate, existing) -> existing.isBackwardCompatible(toValidate);
        return this;
    }

    public SchemaValidatorBuilder mutualReadStrategy() {
        this.strategy = (toValidate, existing) -> {
            ArrayList<String> result = new ArrayList<String>();
            result.addAll(existing.isBackwardCompatible(toValidate));
            result.addAll(toValidate.isBackwardCompatible(existing));
            return result;
        };
        return this;
    }

    public SchemaValidator validateLatest() {
        this.valid();
        return (toValidate, schemasInOrder) -> {
            Iterator schemas = schemasInOrder.iterator();
            if (schemas.hasNext()) {
                ParsedSchema existing = (ParsedSchema)schemas.next();
                return this.strategy.validate(toValidate, existing);
            }
            return Collections.emptyList();
        };
    }

    public SchemaValidator validateAll() {
        this.valid();
        return (toValidate, schemasInOrder) -> {
            for (ParsedSchema existing : schemasInOrder) {
                List<String> errorMessages = this.strategy.validate(toValidate, existing);
                if (errorMessages.isEmpty()) continue;
                return errorMessages;
            }
            return Collections.emptyList();
        };
    }

    private void valid() {
        if (null == this.strategy) {
            throw new RuntimeException("SchemaValidationStrategy not specified in builder");
        }
    }
}

