/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.client;

import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.ParsedSchema;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.SchemaProvider;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.client.SchemaRegistryClientConfig;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.client.rest.RestService;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.client.rest.entities.Config;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.client.rest.entities.Mode;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.client.rest.entities.SubjectVersion;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.client.rest.entities.requests.ConfigUpdateRequest;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.client.rest.entities.requests.ModeUpdateRequest;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.client.security.SslFactory;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.utils.BoundedConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedSchemaRegistryClient
implements SchemaRegistryClient {
    private static final Logger log = LoggerFactory.getLogger(CachedSchemaRegistryClient.class);
    private final RestService restService;
    private final int cacheCapacity;
    private final Map<String, Map<ParsedSchema, Integer>> schemaCache;
    private final Map<String, Map<Integer, ParsedSchema>> idCache;
    private final Map<String, Map<ParsedSchema, Integer>> versionCache;
    private final Cache<SubjectAndSchema, Long> missingSchemaCache;
    private final Cache<SubjectAndId, Long> missingIdCache;
    private final Map<String, SchemaProvider> providers;
    private static final String NO_SUBJECT = ":.:";
    private static final int HTTP_NOT_FOUND = 404;
    private static final int SCHEMA_NOT_FOUND_ERROR_CODE = 40403;
    public static final Map<String, String> DEFAULT_REQUEST_PROPERTIES = Collections.singletonMap("Content-Type", "application/vnd.schemaregistry.v1+json");

    public CachedSchemaRegistryClient(String baseUrl, int cacheCapacity) {
        this(new RestService(baseUrl), cacheCapacity);
    }

    public CachedSchemaRegistryClient(List<String> baseUrls, int cacheCapacity) {
        this(new RestService(baseUrls), cacheCapacity);
    }

    public CachedSchemaRegistryClient(RestService restService, int cacheCapacity) {
        this(restService, cacheCapacity, null);
    }

    public CachedSchemaRegistryClient(String baseUrl, int cacheCapacity, Map<String, ?> originals) {
        this(baseUrl, cacheCapacity, originals, null);
    }

    public CachedSchemaRegistryClient(List<String> baseUrls, int cacheCapacity, Map<String, ?> originals) {
        this(baseUrls, cacheCapacity, originals, null);
    }

    public CachedSchemaRegistryClient(List<String> baseUrls, int cacheCapacity, List<SchemaProvider> providers, Map<String, ?> originals) {
        this(new RestService(baseUrls), cacheCapacity, providers, originals, null);
    }

    public CachedSchemaRegistryClient(String baseUrls, int identityMapCapacity, List<SchemaProvider> providers, Map<String, ?> originals) {
        this(new RestService(baseUrls), identityMapCapacity, providers, originals, null);
    }

    public CachedSchemaRegistryClient(RestService restService, int cacheCapacity, Map<String, ?> configs) {
        this(restService, cacheCapacity, null, configs, null);
    }

    public CachedSchemaRegistryClient(String baseUrl, int cacheCapacity, Map<String, ?> originals, Map<String, String> httpHeaders) {
        this(new RestService(baseUrl), cacheCapacity, null, originals, httpHeaders);
    }

    public CachedSchemaRegistryClient(List<String> baseUrls, int cacheCapacity, Map<String, ?> originals, Map<String, String> httpHeaders) {
        this(new RestService(baseUrls), cacheCapacity, null, originals, httpHeaders);
    }

    public CachedSchemaRegistryClient(List<String> baseUrls, int cacheCapacity, List<SchemaProvider> providers, Map<String, ?> originals, Map<String, String> httpHeaders) {
        this(new RestService(baseUrls), cacheCapacity, providers, originals, httpHeaders);
    }

    public CachedSchemaRegistryClient(RestService restService, int cacheCapacity, Map<String, ?> originals, Map<String, String> httpHeaders) {
        this(restService, cacheCapacity, null, originals, httpHeaders);
    }

    public CachedSchemaRegistryClient(RestService restService, int cacheCapacity, List<SchemaProvider> providers, Map<String, ?> configs, Map<String, String> httpHeaders) {
        this(restService, cacheCapacity, providers, configs, httpHeaders, Ticker.systemTicker());
    }

    public CachedSchemaRegistryClient(RestService restService, int cacheCapacity, List<SchemaProvider> providers, Map<String, ?> configs, Map<String, String> httpHeaders, Ticker ticker) {
        this.cacheCapacity = cacheCapacity;
        this.schemaCache = new BoundedConcurrentHashMap<String, Map<ParsedSchema, Integer>>(cacheCapacity);
        this.idCache = new BoundedConcurrentHashMap<String, Map<Integer, ParsedSchema>>(cacheCapacity);
        this.versionCache = new BoundedConcurrentHashMap<String, Map<ParsedSchema, Integer>>(cacheCapacity);
        this.restService = restService;
        this.idCache.put(NO_SUBJECT, new BoundedConcurrentHashMap(cacheCapacity));
        long missingIdTTL = SchemaRegistryClientConfig.getMissingIdTTL(configs);
        long missingSchemaTTL = SchemaRegistryClientConfig.getMissingSchemaTTL(configs);
        int maxMissingCacheSize = SchemaRegistryClientConfig.getMaxMissingCacheSize(configs);
        this.missingSchemaCache = CacheBuilder.newBuilder().maximumSize((long)maxMissingCacheSize).ticker(ticker).expireAfterWrite(missingSchemaTTL, TimeUnit.SECONDS).build();
        this.missingIdCache = CacheBuilder.newBuilder().maximumSize((long)maxMissingCacheSize).ticker(ticker).expireAfterWrite(missingIdTTL, TimeUnit.SECONDS).build();
        this.providers = providers != null && !providers.isEmpty() ? providers.stream().collect(Collectors.toMap(p -> p.schemaType(), p -> p)) : Collections.singletonMap("AVRO", new AvroSchemaProvider());
        HashMap<String, CachedSchemaRegistryClient> schemaProviderConfigs = new HashMap<String, CachedSchemaRegistryClient>();
        schemaProviderConfigs.put("schemaVersionFetcher", this);
        for (SchemaProvider provider : this.providers.values()) {
            provider.configure(schemaProviderConfigs);
        }
        if (httpHeaders != null) {
            restService.setHttpHeaders(httpHeaders);
        }
        if (configs != null && !configs.isEmpty()) {
            Map<String, Object> restConfigs = configs.entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).startsWith("schema.registry.") ? ((String)e.getKey()).substring("schema.registry.".length()) : (String)e.getKey(), Map.Entry::getValue, (existing, replacement) -> replacement));
            restService.configure(restConfigs);
            Map<String, Object> sslConfigs = configs.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("schema.registry.")).collect(Collectors.toMap(e -> ((String)e.getKey()).substring("schema.registry.".length()), Map.Entry::getValue));
            SslFactory sslFactory = new SslFactory(sslConfigs);
            if (sslFactory.sslContext() != null) {
                restService.setSslSocketFactory(sslFactory.sslContext().getSocketFactory());
            }
        }
    }

    @Override
    public Optional<ParsedSchema> parseSchema(String schemaType, String schemaString, List<SchemaReference> references) {
        SchemaProvider schemaProvider;
        if (schemaType == null) {
            schemaType = "AVRO";
        }
        if ((schemaProvider = this.providers.get(schemaType)) == null) {
            log.error("Invalid schema type " + schemaType);
            return Optional.empty();
        }
        return schemaProvider.parseSchema(schemaString, references);
    }

    public Map<String, SchemaProvider> getSchemaProviders() {
        return this.providers;
    }

    private int registerAndGetId(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        return this.restService.registerSchema(schema.canonicalString(), schema.schemaType(), schema.references(), subject, normalize);
    }

    private int registerAndGetId(String subject, ParsedSchema schema, int version, int id, boolean normalize) throws IOException, RestClientException {
        return this.restService.registerSchema(schema.canonicalString(), schema.schemaType(), schema.references(), subject, version, id, normalize);
    }

    protected ParsedSchema getSchemaByIdFromRegistry(int id, String subject) throws IOException, RestClientException {
        SchemaString restSchema;
        if (this.missingIdCache.getIfPresent((Object)new SubjectAndId(subject, id)) != null) {
            throw new RestClientException("Schema " + id + " not found", 404, 40403);
        }
        try {
            restSchema = this.restService.getId(id, subject);
        }
        catch (RestClientException rce) {
            if (this.isSchemaNotFoundException(rce)) {
                this.missingIdCache.put((Object)new SubjectAndId(subject, id), (Object)System.currentTimeMillis());
            }
            throw rce;
        }
        Optional<ParsedSchema> schema = this.parseSchema(restSchema.getSchemaType(), restSchema.getSchemaString(), restSchema.getReferences());
        return schema.orElseThrow(() -> new IOException("Invalid schema " + restSchema.getSchemaString() + " with refs " + restSchema.getReferences() + " of type " + restSchema.getSchemaType()));
    }

    private int getVersionFromRegistry(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        Schema response;
        this.checkMissingSchemaCache(subject, schema, normalize);
        try {
            response = this.restService.lookUpSubjectVersion(schema.canonicalString(), schema.schemaType(), schema.references(), subject, normalize, true);
        }
        catch (RestClientException rce) {
            if (this.isSchemaNotFoundException(rce)) {
                this.missingSchemaCache.put((Object)new SubjectAndSchema(subject, schema, normalize), (Object)System.currentTimeMillis());
            }
            throw rce;
        }
        return response.getVersion();
    }

    private int getIdFromRegistry(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        Schema response;
        this.checkMissingSchemaCache(subject, schema, normalize);
        try {
            response = this.restService.lookUpSubjectVersion(schema.canonicalString(), schema.schemaType(), schema.references(), subject, normalize, false);
        }
        catch (RestClientException rce) {
            if (this.isSchemaNotFoundException(rce)) {
                this.missingSchemaCache.put((Object)new SubjectAndSchema(subject, schema, normalize), (Object)System.currentTimeMillis());
            }
            throw rce;
        }
        return response.getId();
    }

    @Override
    public int register(String subject, ParsedSchema schema) throws IOException, RestClientException {
        return this.register(subject, schema, 0, -1);
    }

    @Override
    public int register(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        return this.register(subject, schema, 0, -1, normalize);
    }

    @Override
    public int register(String subject, ParsedSchema schema, int version, int id) throws IOException, RestClientException {
        return this.register(subject, schema, version, id, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int register(String subject, ParsedSchema schema, int version, int id, boolean normalize) throws IOException, RestClientException {
        Map schemaIdMap = this.schemaCache.computeIfAbsent(subject, k -> new BoundedConcurrentHashMap(this.cacheCapacity));
        Integer cachedId = (Integer)schemaIdMap.get(schema);
        if (cachedId != null) {
            this.checkId(id, cachedId);
            return cachedId;
        }
        CachedSchemaRegistryClient cachedSchemaRegistryClient = this;
        synchronized (cachedSchemaRegistryClient) {
            cachedId = (Integer)schemaIdMap.get(schema);
            if (cachedId != null) {
                this.checkId(id, cachedId);
                return cachedId;
            }
            int retrievedId = id >= 0 ? this.registerAndGetId(subject, schema, version, id, normalize) : this.registerAndGetId(subject, schema, normalize);
            schemaIdMap.put(schema, retrievedId);
            this.idCache.get(NO_SUBJECT).put(retrievedId, schema);
            return retrievedId;
        }
    }

    private void checkId(int id, Integer cachedId) {
        if (id >= 0 && id != cachedId) {
            throw new IllegalStateException("Schema already registered with id " + cachedId + " instead of input id " + id);
        }
    }

    @Override
    public ParsedSchema getSchemaById(int id) throws IOException, RestClientException {
        return this.getSchemaBySubjectAndId(NO_SUBJECT, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParsedSchema getSchemaBySubjectAndId(String subject, int id) throws IOException, RestClientException {
        Map idSchemaMap;
        ParsedSchema cachedSchema;
        if (subject == null) {
            subject = NO_SUBJECT;
        }
        if ((cachedSchema = (ParsedSchema)(idSchemaMap = this.idCache.computeIfAbsent(subject, k -> new BoundedConcurrentHashMap(this.cacheCapacity))).get(id)) != null) {
            return cachedSchema;
        }
        CachedSchemaRegistryClient cachedSchemaRegistryClient = this;
        synchronized (cachedSchemaRegistryClient) {
            cachedSchema = (ParsedSchema)idSchemaMap.get(id);
            if (cachedSchema != null) {
                return cachedSchema;
            }
            ParsedSchema retrievedSchema = this.getSchemaByIdFromRegistry(id, subject);
            idSchemaMap.put(id, retrievedSchema);
            return retrievedSchema;
        }
    }

    @Override
    public List<ParsedSchema> getSchemas(String subjectPrefix, boolean lookupDeletedSchema, boolean latestOnly) throws IOException, RestClientException {
        List<Schema> restSchemas = this.restService.getSchemas(subjectPrefix, lookupDeletedSchema, latestOnly);
        return restSchemas.stream().map(restSchema -> this.parseSchema(restSchema.getSchemaType(), restSchema.getSchema(), restSchema.getReferences())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    @Override
    public Collection<String> getAllSubjectsById(int id) throws IOException, RestClientException {
        return this.restService.getAllSubjectsById(id);
    }

    @Override
    public Collection<SubjectVersion> getAllVersionsById(int id) throws IOException, RestClientException {
        return this.restService.getAllVersionsById(id);
    }

    @Override
    public Schema getByVersion(String subject, int version, boolean lookupDeletedSchema) {
        try {
            return this.restService.getVersion(subject, version, lookupDeletedSchema);
        }
        catch (IOException | RestClientException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SchemaMetadata getSchemaMetadata(String subject, int version) throws IOException, RestClientException {
        Schema response = this.restService.getVersion(subject, version);
        int id = response.getId();
        String schemaType = response.getSchemaType();
        String schema = response.getSchema();
        List<SchemaReference> references = response.getReferences();
        return new SchemaMetadata(id, version, schemaType, references, schema);
    }

    @Override
    public SchemaMetadata getLatestSchemaMetadata(String subject) throws IOException, RestClientException {
        Schema response = this.restService.getLatestVersion(subject);
        int id = response.getId();
        int version = response.getVersion();
        String schemaType = response.getSchemaType();
        String schema = response.getSchema();
        List<SchemaReference> references = response.getReferences();
        return new SchemaMetadata(id, version, schemaType, references, schema);
    }

    @Override
    public int getVersion(String subject, ParsedSchema schema) throws IOException, RestClientException {
        return this.getVersion(subject, schema, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getVersion(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        Map schemaVersionMap = this.versionCache.computeIfAbsent(subject, k -> new BoundedConcurrentHashMap(this.cacheCapacity));
        Integer cachedVersion = (Integer)schemaVersionMap.get(schema);
        if (cachedVersion != null) {
            return cachedVersion;
        }
        CachedSchemaRegistryClient cachedSchemaRegistryClient = this;
        synchronized (cachedSchemaRegistryClient) {
            cachedVersion = (Integer)schemaVersionMap.get(schema);
            if (cachedVersion != null) {
                return cachedVersion;
            }
            int retrievedVersion = this.getVersionFromRegistry(subject, schema, normalize);
            schemaVersionMap.put(schema, retrievedVersion);
            return retrievedVersion;
        }
    }

    @Override
    public List<Integer> getAllVersions(String subject) throws IOException, RestClientException {
        return this.restService.getAllVersions(subject);
    }

    @Override
    public int getId(String subject, ParsedSchema schema) throws IOException, RestClientException {
        return this.getId(subject, schema, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getId(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        Map schemaIdMap = this.schemaCache.computeIfAbsent(subject, k -> new BoundedConcurrentHashMap(this.cacheCapacity));
        Integer cachedId = (Integer)schemaIdMap.get(schema);
        if (cachedId != null) {
            return cachedId;
        }
        CachedSchemaRegistryClient cachedSchemaRegistryClient = this;
        synchronized (cachedSchemaRegistryClient) {
            cachedId = (Integer)schemaIdMap.get(schema);
            if (cachedId != null) {
                return cachedId;
            }
            int retrievedId = this.getIdFromRegistry(subject, schema, normalize);
            schemaIdMap.put(schema, retrievedId);
            this.idCache.get(NO_SUBJECT).put(retrievedId, schema);
            return retrievedId;
        }
    }

    @Override
    public List<Integer> deleteSubject(String subject, boolean isPermanent) throws IOException, RestClientException {
        return this.deleteSubject(DEFAULT_REQUEST_PROPERTIES, subject, isPermanent);
    }

    @Override
    public synchronized List<Integer> deleteSubject(Map<String, String> requestProperties, String subject, boolean isPermanent) throws IOException, RestClientException {
        Objects.requireNonNull(subject, "subject");
        this.versionCache.remove(subject);
        this.idCache.remove(subject);
        this.schemaCache.remove(subject);
        return this.restService.deleteSubject(requestProperties, subject, isPermanent);
    }

    @Override
    public Integer deleteSchemaVersion(String subject, String version, boolean isPermanent) throws IOException, RestClientException {
        return this.deleteSchemaVersion(DEFAULT_REQUEST_PROPERTIES, subject, version, isPermanent);
    }

    @Override
    public synchronized Integer deleteSchemaVersion(Map<String, String> requestProperties, String subject, String version, boolean isPermanent) throws IOException, RestClientException {
        this.versionCache.getOrDefault(subject, Collections.emptyMap()).values().remove(Integer.valueOf(version));
        return this.restService.deleteSchemaVersion(requestProperties, subject, version, isPermanent);
    }

    @Override
    public boolean testCompatibility(String subject, ParsedSchema schema) throws IOException, RestClientException {
        return this.restService.testCompatibility(schema.canonicalString(), schema.schemaType(), schema.references(), subject, "latest", false).isEmpty();
    }

    @Override
    public List<String> testCompatibilityVerbose(String subject, ParsedSchema schema) throws IOException, RestClientException {
        return this.restService.testCompatibility(schema.canonicalString(), schema.schemaType(), schema.references(), subject, "latest", true);
    }

    @Override
    public String updateCompatibility(String subject, String compatibility) throws IOException, RestClientException {
        ConfigUpdateRequest response = this.restService.updateCompatibility(compatibility, subject);
        return response.getCompatibilityLevel();
    }

    @Override
    public String getCompatibility(String subject) throws IOException, RestClientException {
        Config response = this.restService.getConfig(subject);
        return response.getCompatibilityLevel();
    }

    @Override
    public void deleteCompatibility(String subject) throws IOException, RestClientException {
        this.restService.deleteSubjectConfig(subject);
    }

    @Override
    public String setMode(String mode) throws IOException, RestClientException {
        ModeUpdateRequest response = this.restService.setMode(mode);
        return response.getMode();
    }

    @Override
    public String setMode(String mode, String subject) throws IOException, RestClientException {
        ModeUpdateRequest response = this.restService.setMode(mode, subject);
        return response.getMode();
    }

    @Override
    public String getMode() throws IOException, RestClientException {
        Mode response = this.restService.getMode();
        return response.getMode();
    }

    @Override
    public String getMode(String subject) throws IOException, RestClientException {
        Mode response = this.restService.getMode(subject);
        return response.getMode();
    }

    @Override
    public void deleteMode(String subject) throws IOException, RestClientException {
        this.restService.deleteSubjectMode(subject);
    }

    @Override
    public Collection<String> getAllSubjects() throws IOException, RestClientException {
        return this.restService.getAllSubjects();
    }

    @Override
    public Collection<String> getAllSubjectsByPrefix(String subjectPrefix) throws IOException, RestClientException {
        return this.restService.getAllSubjects(subjectPrefix, false);
    }

    @Override
    public synchronized void reset() {
        this.schemaCache.clear();
        this.idCache.clear();
        this.versionCache.clear();
        this.idCache.put(NO_SUBJECT, new BoundedConcurrentHashMap(this.cacheCapacity));
        this.missingSchemaCache.invalidateAll();
        this.missingIdCache.invalidateAll();
    }

    private void checkMissingSchemaCache(String subject, ParsedSchema schema, boolean normalize) throws RestClientException {
        if (this.missingSchemaCache.getIfPresent((Object)new SubjectAndSchema(subject, schema, normalize)) != null) {
            throw new RestClientException("Schema not found", 404, 40403);
        }
    }

    private boolean isSchemaNotFoundException(RestClientException rce) {
        return rce.getStatus() == 404 && rce.getErrorCode() == 40403;
    }

    static class SubjectAndId {
        private final String subject;
        private final int id;

        public SubjectAndId(String subject, int id) {
            this.subject = subject;
            this.id = id;
        }

        public String subject() {
            return this.subject;
        }

        public int id() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubjectAndId that = (SubjectAndId)o;
            return Objects.equals(this.subject, that.subject) && this.id == that.id;
        }

        public int hashCode() {
            return Objects.hash(this.subject, this.id);
        }

        public String toString() {
            return "SubjectAndId{subject='" + this.subject + '\'' + ", id=" + this.id + '}';
        }
    }

    static class SubjectAndSchema {
        private final String subject;
        private final ParsedSchema schema;
        private final boolean normalize;

        public SubjectAndSchema(String subject, ParsedSchema schema, boolean normalize) {
            this.subject = subject;
            this.schema = schema;
            this.normalize = normalize;
        }

        public String subject() {
            return this.subject;
        }

        public ParsedSchema schema() {
            return this.schema;
        }

        public boolean normalize() {
            return this.normalize;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubjectAndSchema that = (SubjectAndSchema)o;
            return Objects.equals(this.subject, that.subject) && this.schema.equals(that.schema) && this.normalize == that.normalize;
        }

        public int hashCode() {
            return Objects.hash(this.subject, this.schema, this.normalize);
        }

        public String toString() {
            return "SubjectAndSchema{subject='" + this.subject + '\'' + ", schema=" + this.schema + ", normalize=" + this.normalize + '}';
        }
    }
}

