/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.kafka.shade.io.confluent.kafka.formatter;

import java.io.BufferedReader;
import java.io.IOException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.pulsar.kafka.shade.avro.AvroRuntimeException;
import org.apache.pulsar.kafka.shade.avro.Schema;
import org.apache.pulsar.kafka.shade.avro.io.DecoderFactory;
import org.apache.pulsar.kafka.shade.avro.util.Utf8;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.formatter.SchemaMessageReader;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.formatter.SchemaMessageSerializer;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.ParsedSchema;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.SchemaProvider;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.avro.AvroSchema;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import org.apache.pulsar.kafka.shade.io.confluent.kafka.serializers.AbstractKafkaAvroSerializer;

public class AvroMessageReader
extends SchemaMessageReader<Object> {
    private final DecoderFactory decoderFactory = DecoderFactory.get();

    public AvroMessageReader() {
    }

    AvroMessageReader(SchemaRegistryClient schemaRegistryClient, Schema keySchema, Schema valueSchema, String topic, boolean parseKey, BufferedReader reader, boolean normalizeSchema, boolean autoRegister, boolean useLatest) {
        super(schemaRegistryClient, new AvroSchema(keySchema), new AvroSchema(valueSchema), topic, parseKey, reader, normalizeSchema, autoRegister, useLatest);
    }

    @Override
    protected SchemaMessageSerializer<Object> createSerializer(SchemaRegistryClient schemaRegistryClient, boolean normalizeSchema, boolean autoRegister, boolean useLatest, Serializer keySerializer) {
        return new AvroMessageSerializer(schemaRegistryClient, normalizeSchema, autoRegister, useLatest, keySerializer);
    }

    @Override
    protected SchemaProvider getProvider() {
        return new AvroSchemaProvider();
    }

    @Override
    protected Object readFrom(String jsonString, ParsedSchema parsedSchema) {
        Schema schema = ((AvroSchema)parsedSchema).rawSchema();
        try {
            Object object = AvroSchemaUtils.toObject(jsonString, (AvroSchema)parsedSchema);
            if (schema.getType().equals((Object)Schema.Type.STRING)) {
                object = ((Utf8)object).toString();
            }
            return object;
        }
        catch (IOException e) {
            throw new SerializationException(String.format("Error deserializing json %s to Avro of schema %s", jsonString, schema), (Throwable)e);
        }
        catch (AvroRuntimeException e) {
            throw new SerializationException(String.format("Error deserializing json %s to Avro of schema %s", jsonString, schema), (Throwable)e);
        }
    }

    static class AvroMessageSerializer
    extends AbstractKafkaAvroSerializer
    implements SchemaMessageSerializer<Object> {
        protected final Serializer keySerializer;

        AvroMessageSerializer(SchemaRegistryClient schemaRegistryClient, boolean normalizeSchema, boolean autoRegister, boolean useLatest, Serializer keySerializer) {
            this.schemaRegistry = schemaRegistryClient;
            this.normalizeSchema = normalizeSchema;
            this.autoRegisterSchema = autoRegister;
            this.useLatestVersion = useLatest;
            this.keySerializer = keySerializer;
        }

        @Override
        public Serializer getKeySerializer() {
            return this.keySerializer;
        }

        @Override
        public byte[] serializeKey(String topic, Object payload) {
            return this.keySerializer.serialize(topic, payload);
        }

        @Override
        public byte[] serialize(String subject, String topic, boolean isKey, Object object, ParsedSchema schema) {
            return super.serializeImpl(subject, object, (AvroSchema)schema);
        }
    }
}

