/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.kafka.shade.org.codehaus.jackson.map.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import org.apache.pulsar.kafka.shade.org.codehaus.jackson.JsonGenerationException;
import org.apache.pulsar.kafka.shade.org.codehaus.jackson.JsonGenerator;
import org.apache.pulsar.kafka.shade.org.codehaus.jackson.JsonNode;
import org.apache.pulsar.kafka.shade.org.codehaus.jackson.JsonProcessingException;
import org.apache.pulsar.kafka.shade.org.codehaus.jackson.map.SerializerProvider;
import org.apache.pulsar.kafka.shade.org.codehaus.jackson.map.TypeSerializer;
import org.apache.pulsar.kafka.shade.org.codehaus.jackson.map.annotate.JacksonStdImpl;
import org.apache.pulsar.kafka.shade.org.codehaus.jackson.map.ser.std.SerializerBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JacksonStdImpl
public class RawSerializer<T>
extends SerializerBase<T> {
    public RawSerializer(Class<?> cls) {
        super(cls, false);
    }

    @Override
    public void serialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        jgen.writeRawValue(value.toString());
    }

    @Override
    public void serializeWithType(T value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        typeSer.writeTypePrefixForScalar(value, jgen);
        this.serialize(value, jgen, provider);
        typeSer.writeTypeSuffixForScalar(value, jgen);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("string", true);
    }
}

