/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.kafka.shade.avro.specific;

import java.io.IOException;
import org.apache.pulsar.kafka.shade.avro.AvroRuntimeException;
import org.apache.pulsar.kafka.shade.avro.Conversion;
import org.apache.pulsar.kafka.shade.avro.Schema;
import org.apache.pulsar.kafka.shade.avro.generic.GenericDatumReader;
import org.apache.pulsar.kafka.shade.avro.io.ResolvingDecoder;
import org.apache.pulsar.kafka.shade.avro.specific.SpecificData;
import org.apache.pulsar.kafka.shade.avro.specific.SpecificRecord;
import org.apache.pulsar.kafka.shade.avro.specific.SpecificRecordBase;
import org.apache.pulsar.kafka.shade.avro.util.ClassUtils;

public class SpecificDatumReader<T>
extends GenericDatumReader<T> {
    public SpecificDatumReader() {
        this(null, null, SpecificData.get());
    }

    public SpecificDatumReader(Class<T> c) {
        this(new SpecificData(c.getClassLoader()));
        this.setSchema(this.getSpecificData().getSchema(c));
    }

    public SpecificDatumReader(Schema schema) {
        this(schema, schema, SpecificData.get());
    }

    public SpecificDatumReader(Schema writer, Schema reader) {
        this(writer, reader, SpecificData.get());
    }

    public SpecificDatumReader(Schema writer, Schema reader, SpecificData data) {
        super(writer, reader, data);
    }

    public SpecificDatumReader(SpecificData data) {
        super(data);
    }

    public SpecificData getSpecificData() {
        return (SpecificData)this.getData();
    }

    @Override
    public void setSchema(Schema actual) {
        SpecificData data;
        Class c;
        if (this.getExpected() == null && actual != null && actual.getType() == Schema.Type.RECORD && (c = (data = this.getSpecificData()).getClass(actual)) != null && SpecificRecord.class.isAssignableFrom(c)) {
            this.setExpected(data.getSchema(c));
        }
        super.setSchema(actual);
    }

    @Override
    protected Class findStringClass(Schema schema) {
        Class stringClass = null;
        switch (schema.getType()) {
            case STRING: {
                stringClass = this.getPropAsClass(schema, "java-class");
                break;
            }
            case MAP: {
                stringClass = this.getPropAsClass(schema, "java-key-class");
            }
        }
        if (stringClass != null) {
            return stringClass;
        }
        return super.findStringClass(schema);
    }

    private Class getPropAsClass(Schema schema, String prop) {
        String name = schema.getProp(prop);
        if (name == null) {
            return null;
        }
        try {
            return ClassUtils.forName(this.getData().getClassLoader(), name);
        }
        catch (ClassNotFoundException e) {
            throw new AvroRuntimeException(e);
        }
    }

    @Override
    protected void readField(Object r, Schema.Field f, Object oldDatum, ResolvingDecoder in, Object state) throws IOException {
        if (r instanceof SpecificRecordBase) {
            Conversion<?> conversion = ((SpecificRecordBase)r).getConversion(f.pos());
            Object datum = conversion != null ? this.readWithConversion(oldDatum, f.schema(), f.schema().getLogicalType(), conversion, in) : this.readWithoutConversion(oldDatum, f.schema(), in);
            this.getData().setField(r, f.name(), f.pos(), datum);
        } else {
            super.readField(r, f, oldDatum, in, state);
        }
    }
}

