/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.binders;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.payloads.MultipartForm;
import org.jclouds.io.payloads.Part;
import org.jclouds.rest.Binder;

@Singleton
public class BindBlobToMultipartForm
implements Binder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input") instanceof Blob, "this binder is only valid for Blobs!");
        Preconditions.checkNotNull(request, "request");
        Blob blob = (Blob)Blob.class.cast(input);
        Part part = Part.create(blob.getMetadata().getName(), blob.getPayload(), new Part.PartOptions().contentType(blob.getMetadata().getContentMetadata().getContentType()));
        request.setPayload(new MultipartForm(part));
        return request;
    }
}

