/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.blobstore.config;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ForwardingObject;
import org.apache.pulsar.jcloud.shade.com.google.inject.AbstractModule;
import org.apache.pulsar.jcloud.shade.com.google.inject.Provides;
import org.apache.pulsar.jcloud.shade.com.google.inject.assistedinject.FactoryModuleBuilder;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.date.TimeStamp;
import org.jclouds.openstack.swift.v1.blobstore.RegionScopedTemporaryUrlBlobSigner;

public class SignUsingTemporaryUrls
extends AbstractModule {
    @Override
    protected void configure() {
        this.install(new FactoryModuleBuilder().build(Factory.class));
    }

    @Provides
    Function<String, BlobRequestSigner> blobRequestSigner(FactoryFunction in) {
        return in;
    }

    @Provides
    @TimeStamp
    protected Long unixEpochTimestamp() {
        return System.currentTimeMillis() / 1000L;
    }

    static class FactoryFunction
    extends ForwardingObject
    implements Function<String, BlobRequestSigner> {
        @Inject
        Factory delegate;

        FactoryFunction() {
        }

        @Override
        protected Factory delegate() {
            return this.delegate;
        }

        @Override
        public BlobRequestSigner apply(String in) {
            return this.delegate.create(in);
        }
    }

    static interface Factory {
        public RegionScopedTemporaryUrlBlobSigner create(String var1);
    }
}

