/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.features;

import java.util.Set;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Named;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.Consumes;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.GET;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.Path;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.PathParam;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.openstack.keystone.v2_0.KeystoneFallbacks;
import org.jclouds.openstack.keystone.v2_0.domain.Role;
import org.jclouds.openstack.keystone.v2_0.domain.User;
import org.jclouds.openstack.keystone.v2_0.functions.internal.ParseUsers;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.openstack.v2_0.services.Identity;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;

@Consumes(value={"application/json"})
@Endpoint(value=Identity.class)
@RequestFilters(value={AuthenticateRequest.class})
public interface UserApi {
    @Named(value="user:list")
    @GET
    @Path(value="/users")
    @ResponseParser(value=ParseUsers.class)
    @Transform(value=ParseUsers.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<User> list();

    @Named(value="user:list")
    @GET
    @Path(value="/users")
    @ResponseParser(value=ParseUsers.class)
    @Fallback(value=KeystoneFallbacks.EmptyPaginatedCollectionOnNotFoundOr404.class)
    public PaginatedCollection<User> list(PaginationOptions var1);

    @Named(value="user:get")
    @GET
    @SelectJson(value={"user"})
    @Path(value="/users/{userId}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public User get(@PathParam(value="userId") String var1);

    @Named(value="user:getByName")
    @GET
    @SelectJson(value={"user"})
    @Path(value="/users")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public User getByName(@QueryParam(value="name") String var1);

    @Named(value="user:listRolesOfUser")
    @GET
    @SelectJson(value={"roles"})
    @Path(value="/users/{userId}/roles")
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<Role> listRolesOfUser(@PathParam(value="userId") String var1);

    @Named(value="user:listRolesOfUserOnTenant")
    @GET
    @SelectJson(value={"roles"})
    @Path(value="/tenants/{tenantId}/users/{userId}/roles")
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<Role> listRolesOfUserOnTenant(@PathParam(value="userId") String var1, @PathParam(value="tenantId") String var2);
}

