/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.functions;

import java.util.Date;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.date.DateService;
import org.jclouds.http.options.GetOptions;

@Singleton
public class HttpGetOptionsListToGetOptions
implements Function<GetOptions[], org.jclouds.blobstore.options.GetOptions> {
    private final DateService dateService;

    @Inject
    HttpGetOptionsListToGetOptions(DateService dateService) {
        this.dateService = Preconditions.checkNotNull(dateService, "dateService");
    }

    @Override
    public org.jclouds.blobstore.options.GetOptions apply(GetOptions[] from) {
        Preconditions.checkNotNull(from, "options");
        org.jclouds.blobstore.options.GetOptions to = new org.jclouds.blobstore.options.GetOptions();
        if (from.length != 0) {
            Date time;
            if (from[0].getIfMatch() != null) {
                to.ifETagMatches(from[0].getIfMatch().replace("\"", ""));
            }
            if (from[0].getIfModifiedSince() != null) {
                time = this.dateService.rfc822DateParse(from[0].getIfModifiedSince());
                to.ifModifiedSince(time);
            }
            if (from[0].getIfNoneMatch() != null) {
                to.ifETagDoesntMatch(from[0].getIfNoneMatch().replace("\"", ""));
            }
            if (from[0].getIfUnmodifiedSince() != null) {
                time = this.dateService.rfc822DateParse(from[0].getIfUnmodifiedSince());
                to.ifUnmodifiedSince(time);
            }
            for (String range : from[0].getRanges()) {
                String[] firstLast = range.split("\\-");
                to.range(Long.parseLong(firstLast[0]), Long.parseLong(firstLast[1]));
            }
        }
        return to;
    }
}

