/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.handlers;

import org.apache.pulsar.jcloud.shade.com.google.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Named;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;

@Singleton
public class KeystoneErrorHandler
implements HttpErrorHandler {
    @Inject(optional=true)
    @Named(value="jclouds.wire.log.sensitive")
    private boolean logSensitiveInformation = false;

    @Override
    public void handleError(HttpCommand command, HttpResponse response) {
        byte[] data = HttpUtils.closeClientButKeepContentStream(response);
        String message = data != null ? new String(data) : null;
        RuntimeException exception = message != null ? new HttpResponseException(command, response, message) : new HttpResponseException(command, response, this.logSensitiveInformation);
        message = message != null ? message : String.format("%s -> %s", command.getCurrentRequest().getRequestLine(), response.getStatusLine());
        switch (response.getStatusCode()) {
            case 400: {
                break;
            }
            case 401: 
            case 403: {
                exception = new AuthorizationException(message, exception);
                break;
            }
            case 404: {
                if (command.getCurrentRequest().getMethod().equals("DELETE")) break;
                exception = new ResourceNotFoundException(message, exception);
            }
        }
        command.setException(exception);
    }
}

