/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.catalog;

import java.net.URI;
import java.util.List;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableList;
import org.apache.pulsar.jcloud.shade.jakarta.annotation.Resource;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.keystone.auth.domain.AuthInfo;
import org.jclouds.openstack.keystone.catalog.ServiceEndpoint;
import org.jclouds.openstack.keystone.v2_0.domain.Access;
import org.jclouds.openstack.keystone.v2_0.domain.Endpoint;
import org.jclouds.openstack.keystone.v2_0.domain.Service;

@Singleton
public class V2ServiceCatalog
implements Supplier<List<ServiceEndpoint>> {
    @Resource
    private Logger logger = Logger.NULL;
    private final Supplier<AuthInfo> authInfo;

    @Inject
    V2ServiceCatalog(Supplier<AuthInfo> authInfo) {
        this.authInfo = authInfo;
    }

    @Override
    public List<ServiceEndpoint> get() {
        Access access = (Access)this.authInfo.get();
        ImmutableList.Builder serviceEndpoints = ImmutableList.builder();
        for (Service service : access) {
            for (Endpoint endpoint : service) {
                if (endpoint.getAdminURL() != null) {
                    serviceEndpoints.add(this.toServiceEndpoint(service.getType(), ServiceEndpoint.Interface.ADMIN).apply(endpoint));
                }
                if (endpoint.getInternalURL() != null) {
                    serviceEndpoints.add(this.toServiceEndpoint(service.getType(), ServiceEndpoint.Interface.INTERNAL).apply(endpoint));
                }
                if (endpoint.getPublicURL() == null) continue;
                serviceEndpoints.add(this.toServiceEndpoint(service.getType(), ServiceEndpoint.Interface.PUBLIC).apply(endpoint));
            }
        }
        return serviceEndpoints.build();
    }

    private Function<Endpoint, ServiceEndpoint> toServiceEndpoint(final String type, final ServiceEndpoint.Interface iface) {
        return new Function<Endpoint, ServiceEndpoint>(){

            @Override
            public ServiceEndpoint apply(Endpoint input) {
                ServiceEndpoint.Builder builder = ServiceEndpoint.builder().id(input.getId()).iface(iface).regionId(input.getRegion()).type(type).version(input.getVersionId());
                switch (iface) {
                    case ADMIN: {
                        builder.url(input.getAdminURL());
                        break;
                    }
                    case INTERNAL: {
                        builder.url(input.getInternalURL());
                        break;
                    }
                    case PUBLIC: {
                        builder.url(input.getPublicURL());
                        break;
                    }
                    case UNRECOGNIZED: {
                        URI url = input.getPublicURL() != null ? input.getPublicURL() : input.getInternalURL();
                        V2ServiceCatalog.this.logger.warn("Unrecognized endpoint interface for %s. Using URL: %s", input, url);
                        builder.url(url);
                    }
                }
                return builder.build();
            }
        };
    }
}

