/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.apachehc.config;

import java.io.Closeable;
import java.io.IOException;
import java.net.ProxySelector;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.inject.AbstractModule;
import org.apache.pulsar.jcloud.shade.com.google.inject.Provides;
import org.apache.pulsar.jcloud.shade.com.google.inject.Scopes;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Named;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.http.HttpCommandExecutorService;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.apachehc.ApacheHCHttpCommandExecutorService;
import org.jclouds.http.config.ConfiguresHttpCommandExecutorService;
import org.jclouds.http.config.SSLModule;
import org.jclouds.lifecycle.Closer;
import org.jclouds.proxy.ProxyConfig;

@ConfiguresHttpCommandExecutorService
public class ApacheHCHttpCommandExecutorServiceModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.install(new SSLModule());
        this.bindClient();
    }

    @Singleton
    @Provides
    final HttpParams newBasicHttpParams(HttpUtils utils) {
        BasicHttpParams params = new BasicHttpParams();
        params.setIntParameter("http.socket.buffer-size", 8192).setBooleanParameter("http.connection.stalecheck", true).setBooleanParameter("http.tcp.nodelay", true).setParameter("http.origin-server", "jclouds/1.0");
        if (utils.getConnectionTimeout() > 0) {
            params.setIntParameter("http.connection.timeout", utils.getConnectionTimeout());
        }
        if (utils.getSocketOpenTimeout() > 0) {
            params.setIntParameter("http.socket.timeout", utils.getSocketOpenTimeout());
        }
        if (utils.getMaxConnections() > 0) {
            ConnManagerParams.setMaxTotalConnections(params, utils.getMaxConnections());
        }
        if (utils.getMaxConnectionsPerHost() > 0) {
            ConnPerRouteBean connectionsPerRoute = new ConnPerRouteBean(utils.getMaxConnectionsPerHost());
            ConnManagerParams.setMaxConnectionsPerRoute(params, connectionsPerRoute);
        }
        HttpProtocolParams.setVersion(params, HttpVersion.HTTP_1_1);
        return params;
    }

    @Singleton
    @Provides
    final X509HostnameVerifier newHostnameVerifier(HttpUtils utils) {
        return utils.relaxHostname() ? SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER : SSLSocketFactory.STRICT_HOSTNAME_VERIFIER;
    }

    @Singleton
    @Provides
    final SSLContext newSSLContext(HttpUtils utils, @Named(value="untrusted") Supplier<SSLContext> untrustedSSLContextProvider) throws NoSuchAlgorithmException, KeyManagementException {
        if (utils.trustAllCerts()) {
            return untrustedSSLContextProvider.get();
        }
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, null, null);
        return context;
    }

    @Singleton
    @Provides
    final ClientConnectionManager newClientConnectionManager(HttpParams params, X509HostnameVerifier verifier, SSLContext context, Closer closer) throws NoSuchAlgorithmException, KeyManagementException {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", PlainSocketFactory.getSocketFactory(), 80));
        SSLSocketFactory sf = new SSLSocketFactory(context);
        sf.setHostnameVerifier(verifier);
        schemeRegistry.register(new Scheme("https", sf, 443));
        final ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager(params, schemeRegistry);
        closer.addToClose(new Closeable(){

            @Override
            public void close() throws IOException {
                cm.shutdown();
            }
        });
        return cm;
    }

    @Provides
    @Singleton
    final HttpClient newDefaultHttpClient(ProxyConfig config, HttpParams params, ClientConnectionManager cm) {
        DefaultHttpClient client = new DefaultHttpClient(cm, params);
        if (config.useSystem()) {
            ProxySelectorRoutePlanner routePlanner = new ProxySelectorRoutePlanner(client.getConnectionManager().getSchemeRegistry(), ProxySelector.getDefault());
            client.setRoutePlanner(routePlanner);
        }
        return client;
    }

    protected void bindClient() {
        this.bind(HttpCommandExecutorService.class).to(ApacheHCHttpCommandExecutorService.class).in(Scopes.SINGLETON);
    }
}

