/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jcloud.shade.com.google.inject.internal;

import java.util.Set;
import org.apache.pulsar.jcloud.shade.com.google.inject.Binding;
import org.apache.pulsar.jcloud.shade.com.google.inject.Key;
import org.apache.pulsar.jcloud.shade.com.google.inject.Provider;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.AbstractBindingProcessor;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.BindingImpl;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.BoundProviderFactory;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.ConstantFactory;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.ConstructorBindingImpl;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.Errors;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.ErrorsException;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.ExposedBindingImpl;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.ExposedKeyFactory;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.FactoryProxy;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.Initializable;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.Initializer;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.InstanceBindingImpl;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.InternalFactory;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.InternalFactoryToInitializableAdapter;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.InternalProviderInstanceBindingImpl;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.LinkedBindingImpl;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.LinkedProviderBindingImpl;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.ProcessedBindingData;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.ProviderInstanceBindingImpl;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.ProviderMethod;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.Scoping;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.ConstructorBinding;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.ConvertedConstantBinding;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.ExposedBinding;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.InjectionPoint;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.InstanceBinding;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.LinkedKeyBinding;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.PrivateElements;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.ProviderBinding;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.ProviderInstanceBinding;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.ProviderKeyBinding;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.UntargettedBinding;

final class BindingProcessor
extends AbstractBindingProcessor {
    private final Initializer initializer;

    BindingProcessor(Errors errors, Initializer initializer, ProcessedBindingData processedBindingData) {
        super(errors, processedBindingData);
        this.initializer = initializer;
    }

    @Override
    public <T> Boolean visit(Binding<T> command) {
        Class<T> rawType = command.getKey().getTypeLiteral().getRawType();
        if (Void.class.equals(rawType)) {
            if (command instanceof ProviderInstanceBinding && ((ProviderInstanceBinding)command).getUserSuppliedProvider() instanceof ProviderMethod) {
                this.errors.voidProviderMethod();
            } else {
                this.errors.missingConstantValues();
            }
            return true;
        }
        if (rawType == Provider.class) {
            this.errors.bindingToProvider();
            return true;
        }
        return (Boolean)command.acceptTargetVisitor(new AbstractBindingProcessor.Processor<T, Boolean>((BindingImpl)command){

            @Override
            public Boolean visit(ConstructorBinding<? extends T> binding) {
                this.prepareBinding();
                try {
                    ConstructorBindingImpl onInjector = ConstructorBindingImpl.create(BindingProcessor.this.injector, this.key, binding.getConstructor(), this.source, this.scoping, BindingProcessor.this.errors, false, false);
                    this.scheduleInitialization(onInjector);
                    BindingProcessor.this.putBinding(onInjector);
                }
                catch (ErrorsException e) {
                    BindingProcessor.this.errors.merge(e.getErrors());
                    BindingProcessor.this.putBinding(BindingProcessor.this.invalidBinding(BindingProcessor.this.injector, this.key, this.source));
                }
                return true;
            }

            @Override
            public Boolean visit(InstanceBinding<? extends T> binding) {
                this.prepareBinding();
                Set<InjectionPoint> injectionPoints = binding.getInjectionPoints();
                Object instance = binding.getInstance();
                InstanceBinding bindingT = binding;
                Initializable ref = BindingProcessor.this.initializer.requestInjection(BindingProcessor.this.injector, null, instance, bindingT, this.source, injectionPoints, BindingProcessor.this.errors);
                ConstantFactory factory = new ConstantFactory(ref);
                InternalFactory scopedFactory = Scoping.scope(this.key, BindingProcessor.this.injector, factory, this.source, this.scoping);
                BindingProcessor.this.putBinding(new InstanceBindingImpl(BindingProcessor.this.injector, this.key, this.source, scopedFactory, injectionPoints, instance));
                return true;
            }

            @Override
            public Boolean visit(ProviderInstanceBinding<? extends T> binding) {
                this.prepareBinding();
                org.apache.pulsar.jcloud.shade.jakarta.inject.Provider provider = binding.getUserSuppliedProvider();
                if (provider instanceof InternalProviderInstanceBindingImpl.Factory) {
                    InternalProviderInstanceBindingImpl.Factory asProviderMethod = (InternalProviderInstanceBindingImpl.Factory)provider;
                    return this.visitInternalProviderInstanceBindingFactory(asProviderMethod);
                }
                Set<InjectionPoint> injectionPoints = binding.getInjectionPoints();
                Initializable initializable = BindingProcessor.this.initializer.requestInjection(BindingProcessor.this.injector, null, provider, null, this.source, injectionPoints, BindingProcessor.this.errors);
                InternalFactoryToInitializableAdapter factory = new InternalFactoryToInitializableAdapter(initializable, this.source, BindingProcessor.this.injector.provisionListenerStore.get(binding));
                InternalFactory scopedFactory = Scoping.scope(this.key, BindingProcessor.this.injector, factory, this.source, this.scoping);
                BindingProcessor.this.putBinding(new ProviderInstanceBindingImpl(BindingProcessor.this.injector, this.key, this.source, scopedFactory, this.scoping, provider, injectionPoints));
                return true;
            }

            @Override
            public Boolean visit(ProviderKeyBinding<? extends T> binding) {
                this.prepareBinding();
                Key providerKey = binding.getProviderKey();
                BoundProviderFactory boundProviderFactory = new BoundProviderFactory(BindingProcessor.this.injector, providerKey, this.source, BindingProcessor.this.injector.provisionListenerStore.get(binding));
                BindingProcessor.this.processedBindingData.addCreationListener(boundProviderFactory);
                InternalFactory scopedFactory = Scoping.scope(this.key, BindingProcessor.this.injector, boundProviderFactory, this.source, this.scoping);
                BindingProcessor.this.putBinding(new LinkedProviderBindingImpl(BindingProcessor.this.injector, this.key, this.source, scopedFactory, this.scoping, providerKey));
                return true;
            }

            @Override
            public Boolean visit(LinkedKeyBinding<? extends T> binding) {
                this.prepareBinding();
                Key linkedKey = binding.getLinkedKey();
                if (this.key.equals(linkedKey)) {
                    BindingProcessor.this.errors.recursiveBinding(this.key, linkedKey);
                }
                FactoryProxy factory = new FactoryProxy(BindingProcessor.this.injector, this.key, linkedKey, this.source);
                BindingProcessor.this.processedBindingData.addCreationListener(factory);
                InternalFactory scopedFactory = Scoping.scope(this.key, BindingProcessor.this.injector, factory, this.source, this.scoping);
                BindingProcessor.this.putBinding(new LinkedBindingImpl(BindingProcessor.this.injector, this.key, this.source, scopedFactory, this.scoping, linkedKey));
                return true;
            }

            private Boolean visitInternalProviderInstanceBindingFactory(InternalProviderInstanceBindingImpl.Factory<T> provider) {
                InternalProviderInstanceBindingImpl binding = new InternalProviderInstanceBindingImpl(BindingProcessor.this.injector, this.key, this.source, provider, Scoping.scope(this.key, BindingProcessor.this.injector, provider, this.source, this.scoping), this.scoping);
                switch (binding.getInitializationTiming()) {
                    case DELAYED: {
                        this.scheduleDelayedInitialization(binding);
                        break;
                    }
                    case EAGER: {
                        this.scheduleInitialization(binding);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                BindingProcessor.this.putBinding(binding);
                return true;
            }

            @Override
            public Boolean visit(UntargettedBinding<? extends T> untargetted) {
                return false;
            }

            @Override
            public Boolean visit(ExposedBinding<? extends T> binding) {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }

            @Override
            public Boolean visit(ConvertedConstantBinding<? extends T> binding) {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }

            @Override
            public Boolean visit(ProviderBinding<? extends T> binding) {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }

            @Override
            protected Boolean visitOther(Binding<? extends T> binding) {
                throw new IllegalStateException("BindingProcessor should override all visitations");
            }
        });
    }

    @Override
    public Boolean visit(PrivateElements privateElements) {
        for (Key<?> key : privateElements.getExposedKeys()) {
            this.bindExposed(privateElements, key);
        }
        return false;
    }

    private <T> void bindExposed(PrivateElements privateElements, Key<T> key) {
        ExposedKeyFactory<T> exposedKeyFactory = new ExposedKeyFactory<T>(key, privateElements);
        this.processedBindingData.addCreationListener(exposedKeyFactory);
        this.putBinding(new ExposedBindingImpl<T>(this.injector, privateElements.getExposedSource(key), key, exposedKeyFactory, privateElements));
    }
}

