/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.apachehc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Throwables;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableSet;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.JcloudsVersion;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.ContentMetadataCodec;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.payloads.BasePayload;
import org.jclouds.io.payloads.ByteArrayPayload;
import org.jclouds.io.payloads.DelegatingPayload;
import org.jclouds.io.payloads.FilePayload;
import org.jclouds.io.payloads.StringPayload;

@Singleton
public class ApacheHCUtils {
    public static final String USER_AGENT = String.format("jclouds/%s httpclient/%s", JcloudsVersion.get(), "4.1.1");
    private final ContentMetadataCodec contentMetadataCodec;

    public ApacheHCUtils(ContentMetadataCodec contentMetadataCodec) {
        this.contentMetadataCodec = contentMetadataCodec;
    }

    public HttpUriRequest convertToApacheRequest(HttpRequest request) {
        HttpRequestBase apacheRequest;
        if (request.getMethod().equals("HEAD")) {
            apacheRequest = new HttpHead(request.getEndpoint());
        } else if (request.getMethod().equals("GET")) {
            apacheRequest = new HttpGet(request.getEndpoint());
        } else if (request.getMethod().equals("DELETE")) {
            apacheRequest = new HttpDelete(request.getEndpoint());
        } else if (request.getMethod().equals("PUT")) {
            apacheRequest = new HttpPut(request.getEndpoint());
            apacheRequest.getParams().setBooleanParameter("http.protocol.expect-continue", true);
        } else if (request.getMethod().equals("POST")) {
            apacheRequest = new HttpPost(request.getEndpoint());
        } else {
            final String method = request.getMethod();
            apacheRequest = request.getPayload() != null ? new HttpEntityEnclosingRequestBase(){

                @Override
                public String getMethod() {
                    return method;
                }
            } : new HttpRequestBase(){

                @Override
                public String getMethod() {
                    return method;
                }
            };
            ((HttpRequestBase)HttpRequestBase.class.cast(apacheRequest)).setURI(request.getEndpoint());
        }
        Payload payload = request.getPayload();
        if (apacheRequest instanceof HttpEntityEnclosingRequest) {
            if (payload != null) {
                this.addEntityForContent((HttpEntityEnclosingRequest)HttpEntityEnclosingRequest.class.cast(apacheRequest), payload);
            }
        } else {
            apacheRequest.addHeader("Content-Length", "0");
        }
        for (Map.Entry<String, String> entry : request.getHeaders().entries()) {
            String header = entry.getKey();
            if (header.equals("Content-Length")) continue;
            apacheRequest.addHeader(header, entry.getValue());
        }
        apacheRequest.addHeader("User-Agent", USER_AGENT);
        return apacheRequest;
    }

    public void addEntityForContent(HttpEntityEnclosingRequest apacheRequest, Payload payload) {
        Payload payload2 = payload = payload instanceof DelegatingPayload ? ((DelegatingPayload)DelegatingPayload.class.cast(payload)).getDelegate() : payload;
        if (payload instanceof StringPayload) {
            StringEntity nStringEntity = null;
            try {
                nStringEntity = new StringEntity((String)payload.getRawContent());
            }
            catch (UnsupportedEncodingException e) {
                throw new UnsupportedOperationException("Encoding not supported", e);
            }
            nStringEntity.setContentType(payload.getContentMetadata().getContentType());
            apacheRequest.setEntity(nStringEntity);
        } else if (payload instanceof FilePayload) {
            apacheRequest.setEntity(new FileEntity((File)payload.getRawContent(), payload.getContentMetadata().getContentType()));
        } else if (payload instanceof ByteArrayPayload) {
            ByteArrayEntity Entity2 = new ByteArrayEntity((byte[])payload.getRawContent());
            Entity2.setContentType(payload.getContentMetadata().getContentType());
            apacheRequest.setEntity(Entity2);
        } else {
            InputStream inputStream = payload.getInput();
            if (payload.getContentMetadata().getContentLength() == null) {
                throw new IllegalArgumentException("you must specify size when content is an InputStream");
            }
            InputStreamEntity entity = new InputStreamEntity(inputStream, payload.getContentMetadata().getContentLength());
            entity.setContentType(payload.getContentMetadata().getContentType());
            apacheRequest.setEntity(entity);
        }
        ImmutableSet<String> desiredHeaders = ImmutableSet.of("Content-Disposition", "Content-Encoding", "Content-Language", "Expires");
        MutableContentMetadata md = payload.getContentMetadata();
        for (Map.Entry<String, String> entry : this.contentMetadataCodec.toHeaders(md).entries()) {
            if (!desiredHeaders.contains(entry.getKey())) continue;
            apacheRequest.addHeader(entry.getKey(), entry.getValue());
        }
        assert (apacheRequest.getEntity() != null);
    }

    public static class HttpEntityPayload
    extends BasePayload<HttpEntity> {
        HttpEntityPayload(HttpEntity content) {
            super(content);
            this.getContentMetadata().setContentType(content.getContentType().getValue());
            this.getContentMetadata().setContentLength(content.getContentLength());
        }

        @Override
        public InputStream openStream() throws IOException {
            try {
                return ((HttpEntity)this.content).getContent();
            }
            catch (IllegalStateException e) {
                throw Throwables.propagate(e);
            }
        }

        @Override
        public boolean isRepeatable() {
            return ((HttpEntity)this.content).isRepeatable();
        }

        @Override
        public void release() {
            try {
                EntityUtils.consume((HttpEntity)this.content);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

