/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.internal;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Predicate;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableMap;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Iterables;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Maps;
import org.apache.pulsar.jcloud.shade.com.google.inject.Binding;
import org.apache.pulsar.jcloud.shade.com.google.inject.Injector;
import org.apache.pulsar.jcloud.shade.com.google.inject.TypeLiteral;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Named;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;

@Singleton
public class FilterStringsBoundToInjectorByName
implements Function<Predicate<String>, Map<String, String>> {
    private final Injector injector;

    @Inject
    public FilterStringsBoundToInjectorByName(Injector injector) {
        this.injector = Preconditions.checkNotNull(injector, "injector");
    }

    @Override
    public Map<String, String> apply(Predicate<String> filter) {
        List<Binding<String>> stringBindings = this.injector.findBindingsByType(TypeLiteral.get(String.class));
        Iterable<Binding<String>> annotatedWithName = Iterables.filter(stringBindings, new Predicate<Binding<String>>(){

            @Override
            public boolean apply(Binding<String> input) {
                Annotation annotation = input.getKey().getAnnotation();
                if (annotation == null) {
                    return false;
                }
                return annotation instanceof Named || annotation instanceof org.apache.pulsar.jcloud.shade.com.google.inject.name.Named;
            }
        });
        ImmutableMap<String, Binding<String>> bindingsByName = Maps.uniqueIndex(annotatedWithName, new Function<Binding<String>, String>(){

            @Override
            public String apply(Binding<String> input) {
                Annotation annotation = input.getKey().getAnnotation();
                return annotation instanceof Named ? ((Named)Named.class.cast(annotation)).value() : ((org.apache.pulsar.jcloud.shade.com.google.inject.name.Named)org.apache.pulsar.jcloud.shade.com.google.inject.name.Named.class.cast(annotation)).value();
            }
        });
        Map<String, Binding<String>> filteredBindingsByName = Maps.filterKeys(bindingsByName, filter);
        Map<String, String> stringBoundByName = Maps.transformValues(filteredBindingsByName, new Function<Binding<String>, String>(){

            @Override
            public String apply(Binding<String> input) {
                return input.getProvider().get();
            }
        });
        return stringBoundByName;
    }
}

