/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.functions.config;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Throwables;
import org.apache.pulsar.jcloud.shade.com.google.inject.AbstractModule;
import org.apache.pulsar.jcloud.shade.com.google.inject.Injector;
import org.apache.pulsar.jcloud.shade.com.google.inject.Provides;
import org.apache.pulsar.jcloud.shade.com.google.inject.Scopes;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.http.functions.ParseSax;
import org.xml.sax.XMLReader;

public class SaxParserModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.bind(ParseSax.Factory.class).to(Factory.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    final SAXParserFactory provideSAXParserFactory() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        return factory;
    }

    static class Factory
    implements ParseSax.Factory {
        private final SAXParserFactory factory;
        private final Injector i;

        @Inject
        Factory(SAXParserFactory factory, Injector i) {
            this.factory = factory;
            this.i = i;
        }

        @Override
        public <T> ParseSax<T> create(ParseSax.HandlerWithResult<T> handler) {
            try {
                SAXParser saxParser = this.factory.newSAXParser();
                XMLReader parser = saxParser.getXMLReader();
                ParseSax<T> returnVal = new ParseSax<T>(parser, handler);
                this.i.injectMembers(returnVal);
                return returnVal;
            }
            catch (Exception e) {
                throw Throwables.propagate(e);
            }
        }
    }
}

