/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloud.config;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableList;
import org.apache.pulsar.jcloud.shade.com.google.gson.Gson;
import org.apache.pulsar.jcloud.shade.com.google.gson.TypeAdapter;
import org.apache.pulsar.jcloud.shade.com.google.gson.TypeAdapterFactory;
import org.apache.pulsar.jcloud.shade.com.google.gson.reflect.TypeToken;
import org.apache.pulsar.jcloud.shade.com.google.gson.stream.JsonReader;
import org.apache.pulsar.jcloud.shade.com.google.gson.stream.JsonToken;
import org.apache.pulsar.jcloud.shade.com.google.gson.stream.JsonWriter;
import org.jclouds.googlecloud.domain.ForwardingListPage;
import org.jclouds.googlecloud.domain.ListPage;

public final class ListPageAdapterFactory
implements TypeAdapterFactory {
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> ownerType) {
        Type type = ownerType.getType();
        if (ownerType.getRawType() != ListPage.class || !(type instanceof ParameterizedType)) {
            return null;
        }
        Type elementType = ((ParameterizedType)type).getActualTypeArguments()[0];
        TypeAdapter<?> itemAdapter = gson.getAdapter(TypeToken.get(elementType));
        return new ListPageAdapter(itemAdapter);
    }

    static final class ListPageAdapter
    extends TypeAdapter<ListPage<?>> {
        private final TypeAdapter<?> itemAdapter;

        ListPageAdapter(TypeAdapter<?> itemAdapter) {
            this.itemAdapter = itemAdapter;
            this.nullSafe();
        }

        @Override
        public void write(JsonWriter out, ListPage<?> value) throws IOException {
            throw new UnsupportedOperationException("We only read ListPages!");
        }

        @Override
        public ListPage<?> read(JsonReader in) throws IOException {
            ImmutableList.Builder<Object> items = ImmutableList.builder();
            String nextPageToken = null;
            in.beginObject();
            while (in.hasNext()) {
                String name = in.nextName();
                if (name.equals("items")) {
                    if (in.peek() == JsonToken.BEGIN_ARRAY) {
                        this.readItems(in, items);
                        continue;
                    }
                    this.readAggregate(in, items);
                    continue;
                }
                if (name.equals("nextPageToken")) {
                    nextPageToken = in.nextString();
                    continue;
                }
                in.skipValue();
            }
            in.endObject();
            return ForwardingListPage.create(items.build(), nextPageToken);
        }

        private void readItems(JsonReader in, ImmutableList.Builder<Object> items) throws IOException {
            in.beginArray();
            while (in.hasNext()) {
                Object item = this.itemAdapter.read(in);
                if (item == null) continue;
                items.add(item);
            }
            in.endArray();
        }

        private void readAggregate(JsonReader in, ImmutableList.Builder<Object> items) throws IOException {
            in.beginObject();
            while (in.hasNext()) {
                String scope = in.nextName();
                in.beginObject();
                while (in.hasNext()) {
                    String resourceTypeOrWarning = in.nextName();
                    if (!resourceTypeOrWarning.equals("warning")) {
                        this.readItems(in, items);
                        continue;
                    }
                    in.skipValue();
                }
                in.endObject();
            }
            in.endObject();
        }
    }
}

