/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.blobstore.functions;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableMap;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Iterables;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.atmos.domain.BoundedSet;
import org.jclouds.atmos.domain.DirectoryEntry;
import org.jclouds.atmos.domain.FileType;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.BlobMetadataImpl;
import org.jclouds.blobstore.domain.internal.MutableBlobMetadataImpl;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.blobstore.domain.internal.StorageMetadataImpl;
import org.jclouds.domain.Location;
import org.jclouds.io.payloads.BaseMutableContentMetadata;

@Singleton
public class DirectoryEntryListToResourceMetadataList
implements Function<BoundedSet<? extends DirectoryEntry>, PageSet<? extends StorageMetadata>> {
    private Supplier<Location> defaultLocation;

    @Inject
    DirectoryEntryListToResourceMetadataList(Supplier<Location> defaultLocation) {
        this.defaultLocation = defaultLocation;
    }

    @Override
    public PageSet<? extends StorageMetadata> apply(BoundedSet<? extends DirectoryEntry> from) {
        return new PageSetImpl<StorageMetadata>(Iterables.transform(from, new Function<DirectoryEntry, StorageMetadata>(){

            @Override
            public StorageMetadata apply(DirectoryEntry from) {
                StorageType type;
                StorageType storageType = type = from.getType() == FileType.DIRECTORY ? StorageType.FOLDER : StorageType.BLOB;
                if (type == StorageType.FOLDER) {
                    return new StorageMetadataImpl(type, from.getObjectID(), from.getObjectName(), (Location)DirectoryEntryListToResourceMetadataList.this.defaultLocation.get(), null, null, null, null, ImmutableMap.of());
                }
                BlobMetadataImpl metadata = new BlobMetadataImpl(from.getObjectID(), from.getObjectName(), (Location)DirectoryEntryListToResourceMetadataList.this.defaultLocation.get(), null, from.getObjectID(), null, from.getModifiedTime(), ImmutableMap.of(), null, null, new BaseMutableContentMetadata());
                MutableBlobMetadataImpl mutable = new MutableBlobMetadataImpl(metadata);
                mutable.setSize(from.getSize());
                return mutable;
            }
        }), from.getToken());
    }
}

