/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Optional;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Predicates;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Throwables;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.FluentIterable;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableList;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableMap;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableMultimap;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableSet;
import org.apache.pulsar.jcloud.shade.com.google.common.primitives.Ints;
import org.jclouds.Fallback;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.IterableWithMarkers;
import org.jclouds.collect.PagedIterable;
import org.jclouds.collect.PagedIterables;
import org.jclouds.http.HttpUtils;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.util.Throwables2;

public final class Fallbacks {
    private Fallbacks() {
    }

    public static <T> T valOnNotFoundOr404(T val, Throwable t) {
        if (Fallbacks.containsResourceNotFoundException(Preconditions.checkNotNull(t, "throwable")) || HttpUtils.contains404(t)) {
            return val;
        }
        throw Throwables.propagate(t);
    }

    private static boolean containsResourceNotFoundException(Throwable from) {
        return Throwables2.getFirstThrowableOfType(from, ResourceNotFoundException.class) != null;
    }

    public static final class EmptyMultimapOnNotFoundOr404
    implements Fallback<ImmutableMultimap<Object, Object>> {
        @Override
        public ImmutableMultimap<Object, Object> createOrPropagate(Throwable t) throws Exception {
            return Fallbacks.valOnNotFoundOr404(ImmutableMultimap.of(), Preconditions.checkNotNull(t, "throwable"));
        }
    }

    public static final class EmptyMapOnNotFoundOr404
    implements Fallback<ImmutableMap<Object, Object>> {
        @Override
        public ImmutableMap<Object, Object> createOrPropagate(Throwable t) throws Exception {
            return Fallbacks.valOnNotFoundOr404(ImmutableMap.of(), Preconditions.checkNotNull(t, "throwable"));
        }
    }

    public static final class EmptySetOnNotFoundOr404
    implements Fallback<ImmutableSet<Object>> {
        @Override
        public ImmutableSet<Object> createOrPropagate(Throwable t) throws Exception {
            return Fallbacks.valOnNotFoundOr404(ImmutableSet.of(), Preconditions.checkNotNull(t, "throwable"));
        }
    }

    public static final class EmptyListOnNotFoundOr404
    implements Fallback<ImmutableList<Object>> {
        @Override
        public ImmutableList<Object> createOrPropagate(Throwable t) throws Exception {
            return Fallbacks.valOnNotFoundOr404(ImmutableList.of(), Preconditions.checkNotNull(t, "throwable"));
        }
    }

    public static final class EmptyPagedIterableOnNotFoundOr404
    implements Fallback<PagedIterable<Object>> {
        @Override
        public PagedIterable<Object> createOrPropagate(Throwable t) throws Exception {
            return Fallbacks.valOnNotFoundOr404(PagedIterables.of(IterableWithMarkers.from(ImmutableSet.of())), Preconditions.checkNotNull(t, "throwable"));
        }
    }

    public static final class EmptyIterableWithMarkerOnNotFoundOr404
    implements Fallback<IterableWithMarker<Object>> {
        @Override
        public IterableWithMarker<Object> createOrPropagate(Throwable t) throws Exception {
            return Fallbacks.valOnNotFoundOr404(IterableWithMarkers.from(ImmutableSet.of()), Preconditions.checkNotNull(t, "throwable"));
        }
    }

    public static final class EmptyFluentIterableOnNotFoundOr404
    implements Fallback<FluentIterable<Object>> {
        @Override
        public FluentIterable<Object> createOrPropagate(Throwable t) throws Exception {
            return Fallbacks.valOnNotFoundOr404(FluentIterable.from(ImmutableSet.of()), Preconditions.checkNotNull(t, "throwable"));
        }
    }

    public static final class AbsentOn403Or404Or500
    implements Fallback<Optional<Object>> {
        @Override
        public Optional<Object> createOrPropagate(Throwable t) throws Exception {
            Boolean returnVal = HttpUtils.returnValueOnCodeOrNull(Preconditions.checkNotNull(t, "throwable"), true, Predicates.in(Ints.asList(403, 404, 500)));
            if (returnVal != null) {
                return Optional.absent();
            }
            throw Throwables.propagate(t);
        }
    }

    public static final class FalseOnNotFoundOr422
    implements Fallback<Boolean> {
        @Override
        public Boolean createOrPropagate(Throwable t) throws Exception {
            if (Fallbacks.containsResourceNotFoundException(Preconditions.checkNotNull(t, "throwable")) || HttpUtils.returnValueOnCodeOrNull(t, true, Predicates.equalTo(422)) != null) {
                return false;
            }
            throw Throwables.propagate(t);
        }
    }

    public static final class FalseOnNotFoundOr404
    implements Fallback<Boolean> {
        @Override
        public Boolean createOrPropagate(Throwable t) throws Exception {
            return Fallbacks.valOnNotFoundOr404(false, Preconditions.checkNotNull(t, "throwable"));
        }
    }

    public static final class TrueOnNotFoundOr404
    implements Fallback<Boolean> {
        @Override
        public Boolean createOrPropagate(Throwable t) throws Exception {
            return Fallbacks.valOnNotFoundOr404(true, Preconditions.checkNotNull(t, "throwable"));
        }
    }

    public static final class VoidOnNotFoundOr404
    implements Fallback<Void> {
        @Override
        public Void createOrPropagate(Throwable t) throws Exception {
            return Fallbacks.valOnNotFoundOr404(null, Preconditions.checkNotNull(t, "throwable"));
        }
    }

    public static final class NullOnNotFoundOr404
    implements Fallback<Object> {
        @Override
        public Object createOrPropagate(Throwable t) throws Exception {
            return Fallbacks.valOnNotFoundOr404(null, Preconditions.checkNotNull(t, "throwable"));
        }
    }
}

