/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.xml;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Optional;
import org.apache.pulsar.jcloud.shade.com.google.common.cache.LoadingCache;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.s3.Bucket;
import org.jclouds.util.SaxUtils;

public class LocationConstraintHandler
extends ParseSax.HandlerWithResult<String> {
    private final LoadingCache<String, Optional<String>> bucketToRegion;
    private StringBuilder currentText = new StringBuilder();
    private String region;
    private String bucket;

    @Inject
    public LocationConstraintHandler(@Bucket LoadingCache<String, Optional<String>> bucketToRegion) {
        this.bucketToRegion = bucketToRegion;
    }

    @Override
    public String getResult() {
        return this.region;
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        this.region = LocationConstraintHandler.fromValue(SaxUtils.currentOrNull(this.currentText));
        this.bucketToRegion.put(this.bucket, Optional.fromNullable(this.region));
    }

    @Override
    public LocationConstraintHandler setContext(HttpRequest request) {
        super.setContext(request);
        this.setBucket(((GeneratedHttpRequest)GeneratedHttpRequest.class.cast(this.getRequest())).getInvocation().getArgs().get(0).toString());
        return this;
    }

    void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public static String fromValue(String v) {
        if (v == null || "".equals(v)) {
            return "us-standard";
        }
        if ("EU".equals(v)) {
            return "eu-west-1";
        }
        return v;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

