/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.functions;

import java.util.concurrent.ExecutionException;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Optional;
import org.apache.pulsar.jcloud.shade.com.google.common.cache.CacheLoader;
import org.apache.pulsar.jcloud.shade.com.google.common.cache.LoadingCache;
import org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.pulsar.jcloud.shade.jakarta.annotation.Resource;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.s3.Bucket;

@Singleton
public class GetRegionForBucket
implements Function<String, Optional<String>> {
    @Resource
    protected Logger logger = Logger.NULL;
    protected final LoadingCache<String, Optional<String>> bucketToRegion;

    @Inject
    public GetRegionForBucket(@Bucket LoadingCache<String, Optional<String>> bucketToRegion) {
        this.bucketToRegion = bucketToRegion;
    }

    @Override
    public Optional<String> apply(String bucket) {
        try {
            return this.bucketToRegion.get(bucket);
        }
        catch (ExecutionException e) {
            this.logger.debug("error looking up region for bucket %s: %s", bucket, e);
        }
        catch (UncheckedExecutionException e) {
            this.logger.debug("error looking up region for bucket %s: %s", bucket, e);
        }
        catch (CacheLoader.InvalidCacheLoadException e) {
            this.logger.trace("bucket %s not found: %s", bucket, e);
        }
        return Optional.absent();
    }
}

