/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.filters;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Joiner;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Strings;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableMap;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableSortedMap;
import org.apache.pulsar.jcloud.shade.com.google.common.hash.HashCode;
import org.apache.pulsar.jcloud.shade.com.google.common.io.BaseEncoding;
import org.apache.pulsar.jcloud.shade.com.google.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Named;
import org.jclouds.aws.domain.SessionCredentials;
import org.jclouds.crypto.Crypto;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.internal.SignatureWire;
import org.jclouds.io.Payload;
import org.jclouds.location.Provider;
import org.jclouds.s3.filters.Aws4SignerBase;
import org.jclouds.util.Closeables2;

public class Aws4SignerForAuthorizationHeader
extends Aws4SignerBase {
    @Inject
    public Aws4SignerForAuthorizationHeader(SignatureWire signatureWire, @Named(value="jclouds.s3.virtual-host-buckets") boolean isVhostStyle, @Named(value="jclouds.aws.header.tag") String headerTag, @Provider Supplier<Credentials> creds, @TimeStamp Supplier<Date> timestampProvider, Aws4SignerBase.ServiceAndRegion serviceAndRegion, Crypto crypto) {
        super(signatureWire, headerTag, creds, timestampProvider, serviceAndRegion, crypto);
    }

    protected HttpRequest sign(HttpRequest request) throws HttpException {
        HashCode md5;
        String contentLength;
        Preconditions.checkNotNull(request, "request is not ready to sign");
        Preconditions.checkNotNull(request.getEndpoint(), "request is not ready to sign, request.endpoint not present.");
        Payload payload = request.getPayload();
        String host = request.getEndpoint().getHost();
        Date date = (Date)this.timestampProvider.get();
        String timestamp = this.timestampFormat.format(date);
        String datestamp = this.dateFormat.format(date);
        String service = this.serviceAndRegion.service();
        String region = this.serviceAndRegion.region(host);
        String credentialScope = Joiner.on('/').join(datestamp, region, service, "aws4_request");
        HttpRequest.Builder requestBuilder = (HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder().removeHeader("Authorization")).removeHeader("Date");
        ImmutableSortedMap.Builder<String, String> signedHeadersBuilder = ImmutableSortedMap.naturalOrder();
        String contentType = this.getContentType(request);
        if (!Strings.isNullOrEmpty(contentType)) {
            requestBuilder.replaceHeader("Content-Type", contentType);
            ((ImmutableMap.Builder)signedHeadersBuilder).put("Content-Type".toLowerCase(), contentType);
        }
        if (!Strings.isNullOrEmpty(contentLength = this.getContentLength(request))) {
            requestBuilder.replaceHeader("Content-Length", contentLength);
            ((ImmutableMap.Builder)signedHeadersBuilder).put("Content-Length".toLowerCase(), contentLength);
        }
        String contentMD5 = request.getFirstHeaderOrNull("Content-MD5");
        if (payload != null && (md5 = payload.getContentMetadata().getContentMD5AsHashCode()) != null) {
            contentMD5 = BaseEncoding.base64().encode(md5.asBytes());
        }
        if (contentMD5 != null) {
            requestBuilder.replaceHeader("Content-MD5", contentMD5);
            ((ImmutableMap.Builder)signedHeadersBuilder).put("Content-MD5".toLowerCase(), contentMD5);
        }
        host = Aws4SignerForAuthorizationHeader.hostHeaderFor(request.getEndpoint());
        requestBuilder.replaceHeader("Host", host);
        ((ImmutableMap.Builder)signedHeadersBuilder).put("Host".toLowerCase(), host);
        String userAgent = request.getFirstHeaderOrNull("User-Agent");
        if (userAgent != null) {
            ((ImmutableMap.Builder)signedHeadersBuilder).put("User-Agent".toLowerCase(), userAgent);
        }
        this.appendAmzHeaders(request, signedHeadersBuilder);
        Credentials credentials = (Credentials)this.creds.get();
        if (credentials instanceof SessionCredentials) {
            String token = ((SessionCredentials)SessionCredentials.class.cast(credentials)).getSessionToken();
            requestBuilder.replaceHeader("X-Amz-Security-Token", token);
            ((ImmutableMap.Builder)signedHeadersBuilder).put("X-Amz-Security-Token".toLowerCase(), token);
        }
        String contentSha256 = this.getPayloadHash(request);
        requestBuilder.replaceHeader("x-amz-content-sha256", contentSha256);
        ((ImmutableMap.Builder)signedHeadersBuilder).put("x-amz-content-sha256".toLowerCase(), contentSha256);
        requestBuilder.replaceHeader("X-Amz-Date", timestamp);
        ((ImmutableMap.Builder)signedHeadersBuilder).put("X-Amz-Date".toLowerCase(), timestamp);
        ImmutableMap<String, String> signedHeaders = ((ImmutableMap.Builder)signedHeadersBuilder).build();
        String stringToSign = this.createStringToSign(request.getMethod(), request.getEndpoint(), signedHeaders, timestamp, credentialScope, contentSha256);
        this.signatureWire.getWireLog().debug("<< " + stringToSign, new Object[0]);
        byte[] signatureKey = this.signatureKey(credentials.credential, datestamp, region, service);
        String signature = BaseEncoding.base16().lowerCase().encode(this.hmacSHA256(stringToSign, signatureKey));
        StringBuilder authorization = new StringBuilder("AWS4-HMAC-SHA256").append(" ");
        authorization.append("Credential=").append(Joiner.on("/").join(credentials.identity, credentialScope, new Object[0])).append(", ");
        authorization.append("SignedHeaders=").append(Joiner.on(";").join(signedHeaders.keySet())).append(", ");
        authorization.append("Signature=").append(signature);
        return ((HttpRequest.Builder)requestBuilder.replaceHeader("Authorization", authorization.toString())).build();
    }

    protected String getPayloadHash(HttpRequest request) {
        Payload payload = request.getPayload();
        if (payload == null || "0".equals(this.getContentLength(request))) {
            return this.getEmptyPayloadContentHash();
        }
        return this.calculatePayloadContentHash(payload);
    }

    protected String getEmptyPayloadContentHash() {
        return BaseEncoding.base16().lowerCase().encode(Aws4SignerForAuthorizationHeader.hash(new ByteArrayInputStream(new byte[0])));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String calculatePayloadContentHash(Payload payload) {
        InputStream payloadStream;
        try {
            payloadStream = payload.openStream();
        }
        catch (IOException e) {
            throw new HttpException("unable to open payload stream to calculate AWS4 signature.", e);
        }
        try {
            String string = BaseEncoding.base16().lowerCase().encode(Aws4SignerForAuthorizationHeader.hash(payloadStream));
            return string;
        }
        finally {
            this.closeOrResetPayloadStream(payloadStream, payload.isRepeatable());
        }
    }

    void closeOrResetPayloadStream(InputStream payloadStream, boolean repeatable) {
        if (repeatable) {
            Closeables2.closeQuietly(payloadStream);
        } else {
            try {
                payloadStream.reset();
            }
            catch (IOException e) {
                throw new HttpException("unable to reset unrepeatable payload stream after calculating AWS4 signature.", e);
            }
        }
    }
}

