/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.features;

import org.apache.pulsar.jcloud.shade.com.google.common.annotations.Beta;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Joiner;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Iterables;
import org.apache.pulsar.jcloud.shade.com.google.common.net.UrlEscapers;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Named;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.Consumes;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.DELETE;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.PUT;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.Path;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.PathParam;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.QueryParam;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.StringPayload;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.openstack.swift.v1.binders.SetPayload;
import org.jclouds.openstack.swift.v1.domain.BulkDeleteResponse;
import org.jclouds.openstack.swift.v1.domain.ExtractArchiveResponse;
import org.jclouds.rest.Binder;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;

@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Beta
public interface BulkApi {
    @Named(value="bulk:extractArchive")
    @PUT
    @Path(value="/{path}")
    public ExtractArchiveResponse extractArchive(@PathParam(value="path") String var1, @BinderParam(value=SetPayload.class) Payload var2, @QueryParam(value="extract-archive") String var3);

    @Named(value="bulk:delete")
    @DELETE
    @QueryParams(keys={"bulk-delete"})
    public BulkDeleteResponse bulkDelete(@BinderParam(value=UrlEncodeAndJoinOnNewline.class) Iterable<String> var1);

    public static class UrlEncodeAndJoinOnNewline
    implements Binder {
        @Override
        public <R extends HttpRequest> R bindToRequest(R request, Object input) {
            String encodedAndNewlineDelimited = Joiner.on('\n').join(Iterables.transform((Iterable)Iterable.class.cast(input), UrlEscapers.urlFragmentEscaper().asFunction()));
            StringPayload payload = Payloads.newStringPayload(encodedAndNewlineDelimited);
            payload.getContentMetadata().setContentType("text/plain");
            return (R)((HttpRequest.Builder)request.toBuilder().payload(payload)).build();
        }
    }
}

