/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v3.parsers;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.inject.Inject;
import org.apache.pulsar.jcloud.shade.com.google.inject.TypeLiteral;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.json.internal.GsonWrapper;
import org.jclouds.openstack.keystone.v3.domain.Token;

@Singleton
public class ParseTokenFromHttpResponse
implements Function<HttpResponse, Token> {
    private final ParseFirstJsonValueNamed<Token> parser;

    @Inject
    ParseTokenFromHttpResponse(GsonWrapper gsonView) {
        this.parser = new ParseFirstJsonValueNamed<Token>(gsonView, TypeLiteral.get(Token.class), "token");
    }

    @Override
    public Token apply(HttpResponse response) {
        Preconditions.checkNotNull(response, "response");
        Token toParse = this.parser.apply(response);
        Preconditions.checkNotNull(toParse, "parsed result from %s", (Object)response);
        String xSubjectToken = response.getFirstHeaderOrNull("X-Subject-Token");
        return toParse.toBuilder().id(xSubjectToken).build();
    }
}

