/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.oauth.v2.filters;

import java.util.concurrent.TimeUnit;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Joiner;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.cache.CacheBuilder;
import org.apache.pulsar.jcloud.shade.com.google.common.cache.CacheLoader;
import org.apache.pulsar.jcloud.shade.com.google.common.cache.LoadingCache;
import org.apache.pulsar.jcloud.shade.com.google.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Named;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.location.Provider;
import org.jclouds.oauth.v2.AuthorizationApi;
import org.jclouds.oauth.v2.config.OAuthConfigFactory;
import org.jclouds.oauth.v2.domain.ClientSecret;
import org.jclouds.oauth.v2.domain.Token;
import org.jclouds.oauth.v2.filters.OAuthFilter;

public class ClientCredentialsSecretFlow
implements OAuthFilter {
    private static final Joiner ON_SPACE = Joiner.on(" ");
    private final Supplier<Credentials> credentialsSupplier;
    private final LoadingCache<ClientSecret, Token> tokenCache;
    private final OAuthConfigFactory oauthConfigFactory;

    @Inject
    ClientCredentialsSecretFlow(AuthorizeToken loader, @Named(value="jclouds.session-interval") long tokenDuration, @Provider Supplier<Credentials> credentialsSupplier, OAuthConfigFactory oauthConfigFactory) {
        this.credentialsSupplier = credentialsSupplier;
        this.oauthConfigFactory = oauthConfigFactory;
        long cacheExpirationSeconds = tokenDuration > 30L ? tokenDuration - 30L : tokenDuration;
        this.tokenCache = CacheBuilder.newBuilder().expireAfterWrite(cacheExpirationSeconds, TimeUnit.SECONDS).build(loader);
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        OAuthConfigFactory.OAuthConfig oauthConfig = this.oauthConfigFactory.forRequest(request);
        ClientSecret client = ClientSecret.create(this.credentialsSupplier.get().identity, this.credentialsSupplier.get().credential, oauthConfig.resource(), oauthConfig.scopes().isEmpty() ? null : ON_SPACE.join(oauthConfig.scopes()));
        Token token = this.tokenCache.getUnchecked(client);
        String authorization = String.format("%s %s", token.tokenType(), token.accessToken());
        return ((HttpRequest.Builder)request.toBuilder().addHeader("Authorization", authorization)).build();
    }

    static final class AuthorizeToken
    extends CacheLoader<ClientSecret, Token> {
        private final AuthorizationApi api;

        @Inject
        AuthorizeToken(AuthorizationApi api) {
            this.api = api;
        }

        @Override
        public Token load(ClientSecret key) throws Exception {
            return this.api.authorizeClientSecret(key.clientId(), key.clientSecret(), key.resource(), key.scope());
        }
    }
}

