/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.json.config;

import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableList;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableMap;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableSet;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Maps;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Sets;
import org.apache.pulsar.jcloud.shade.com.google.common.io.BaseEncoding;
import org.apache.pulsar.jcloud.shade.com.google.common.primitives.Bytes;
import org.apache.pulsar.jcloud.shade.com.google.gson.ExclusionStrategy;
import org.apache.pulsar.jcloud.shade.com.google.gson.FieldAttributes;
import org.apache.pulsar.jcloud.shade.com.google.gson.Gson;
import org.apache.pulsar.jcloud.shade.com.google.gson.GsonBuilder;
import org.apache.pulsar.jcloud.shade.com.google.gson.TypeAdapter;
import org.apache.pulsar.jcloud.shade.com.google.gson.TypeAdapterFactory;
import org.apache.pulsar.jcloud.shade.com.google.gson.internal.ConstructorConstructor;
import org.apache.pulsar.jcloud.shade.com.google.gson.internal.Excluder;
import org.apache.pulsar.jcloud.shade.com.google.gson.internal.JsonReaderInternalAccess;
import org.apache.pulsar.jcloud.shade.com.google.gson.reflect.TypeToken;
import org.apache.pulsar.jcloud.shade.com.google.gson.stream.JsonReader;
import org.apache.pulsar.jcloud.shade.com.google.gson.stream.JsonToken;
import org.apache.pulsar.jcloud.shade.com.google.gson.stream.JsonWriter;
import org.apache.pulsar.jcloud.shade.com.google.inject.AbstractModule;
import org.apache.pulsar.jcloud.shade.com.google.inject.ImplementedBy;
import org.apache.pulsar.jcloud.shade.com.google.inject.Inject;
import org.apache.pulsar.jcloud.shade.com.google.inject.Provides;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Provider;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.date.DateService;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.JsonBall;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.json.Json;
import org.jclouds.json.SerializedNames;
import org.jclouds.json.internal.DeserializationConstructorAndReflectiveTypeAdapterFactory;
import org.jclouds.json.internal.EnumTypeAdapterThatReturnsFromValue;
import org.jclouds.json.internal.GsonWrapper;
import org.jclouds.json.internal.NamingStrategies;
import org.jclouds.json.internal.NullFilteringTypeAdapterFactories;
import org.jclouds.json.internal.NullHackJsonLiteralAdapter;
import org.jclouds.json.internal.OptionalTypeAdapterFactory;

public class GsonModule
extends AbstractModule {
    @Provides
    @Singleton
    final Gson provideGson(TypeAdapter<JsonBall> jsonAdapter, DateAdapter adapter, ByteListAdapter byteListAdapter, ByteArrayAdapter byteArrayAdapter, PropertiesAdapter propertiesAdapter, JsonAdapterBindings bindings, CredentialsAdapterFactory credentialsAdapterFactory, OptionalTypeAdapterFactory optional, NullFilteringTypeAdapterFactories.SetTypeAdapterFactory set, NullFilteringTypeAdapterFactories.ImmutableSetTypeAdapterFactory immutableSet, NullFilteringTypeAdapterFactories.MapTypeAdapterFactory map, NullFilteringTypeAdapterFactories.MultimapTypeAdapterFactory multimap, NullFilteringTypeAdapterFactories.IterableTypeAdapterFactory iterable, NullFilteringTypeAdapterFactories.CollectionTypeAdapterFactory collection, NullFilteringTypeAdapterFactories.ListTypeAdapterFactory list, NullFilteringTypeAdapterFactories.ImmutableListTypeAdapterFactory immutableList, NullFilteringTypeAdapterFactories.FluentIterableTypeAdapterFactory fluentIterable, NullFilteringTypeAdapterFactories.ImmutableMapTypeAdapterFactory immutableMap, DefaultExclusionStrategy exclusionStrategy) {
        NamingStrategies.AnnotationOrNameFieldNamingStrategy serializationPolicy = new NamingStrategies.AnnotationOrNameFieldNamingStrategy(ImmutableSet.of(new NamingStrategies.ExtractSerializedName(), new NamingStrategies.ExtractNamed()));
        GsonBuilder builder = new GsonBuilder().setFieldNamingStrategy(serializationPolicy).setExclusionStrategies(exclusionStrategy);
        builder.registerTypeAdapter((Type)((Object)Properties.class), propertiesAdapter.nullSafe());
        builder.registerTypeAdapter((Type)((Object)Date.class), adapter.nullSafe());
        builder.registerTypeAdapter((Type)((Object)byte[].class), byteArrayAdapter.nullSafe());
        builder.registerTypeAdapter((Type)((Object)JsonBall.class), jsonAdapter.nullSafe());
        builder.registerTypeAdapter((Type)((Object)File.class), new FileTypeAdapter());
        builder.registerTypeAdapterFactory(credentialsAdapterFactory);
        builder.registerTypeAdapterFactory(optional);
        builder.registerTypeAdapterFactory(iterable);
        builder.registerTypeAdapterFactory(collection);
        builder.registerTypeAdapterFactory(list);
        builder.registerTypeAdapter(new TypeToken<List<Byte>>(){}.getType(), byteListAdapter.nullSafe());
        builder.registerTypeAdapterFactory(immutableList);
        builder.registerTypeAdapterFactory(set);
        builder.registerTypeAdapterFactory(immutableSet);
        builder.registerTypeAdapterFactory(map);
        builder.registerTypeAdapterFactory(multimap);
        builder.registerTypeAdapterFactory(fluentIterable);
        builder.registerTypeAdapterFactory(immutableMap);
        NamingStrategies.AnnotationConstructorNamingStrategy deserializationPolicy = new NamingStrategies.AnnotationConstructorNamingStrategy(ImmutableSet.of(ConstructorProperties.class, SerializedNames.class, Inject.class), ImmutableSet.of(new NamingStrategies.ExtractNamed()));
        builder.registerTypeAdapterFactory(new DeserializationConstructorAndReflectiveTypeAdapterFactory(new ConstructorConstructor(ImmutableMap.of(), false, ImmutableList.of()), serializationPolicy, Excluder.DEFAULT, deserializationPolicy));
        builder.registerTypeHierarchyAdapter(Enum.class, new EnumTypeAdapterThatReturnsFromValue());
        for (Map.Entry<Type, Object> binding : bindings.getBindings().entrySet()) {
            builder.registerTypeAdapter(binding.getKey(), binding.getValue());
        }
        for (TypeAdapterFactory factory : bindings.getFactories()) {
            builder.registerTypeAdapterFactory(factory);
        }
        return builder.create();
    }

    @Provides
    @Singleton
    protected final TypeAdapter<JsonBall> provideJsonBallAdapter(NullHackJsonBallAdapter in) {
        return in;
    }

    @Override
    protected void configure() {
        this.bind(Json.class).to(GsonWrapper.class);
    }

    @Singleton
    public static class JsonAdapterBindings {
        private final Map<Type, Object> bindings = Maps.newHashMap();
        private final Set<TypeAdapterFactory> factories = Sets.newHashSet();

        @Inject(optional=true)
        public void setBindings(Map<Type, Object> bindings) {
            this.bindings.putAll(bindings);
        }

        @Inject(optional=true)
        public void setFactories(Set<TypeAdapterFactory> factories) {
            this.factories.addAll(factories);
        }

        public Map<Type, Object> getBindings() {
            return this.bindings;
        }

        public Set<TypeAdapterFactory> getFactories() {
            return this.factories;
        }
    }

    public static class CredentialsAdapterFactory
    extends TypeAdapter<Credentials>
    implements TypeAdapterFactory {
        @Override
        public void write(JsonWriter out, Credentials credentials) throws IOException {
            out.beginObject();
            if (credentials instanceof LoginCredentials) {
                LoginCredentials login = (LoginCredentials)credentials;
                out.name("user");
                out.value(login.getUser());
                out.name("password");
                out.value(login.getOptionalPassword().orNull());
                out.name("privateKey");
                out.value(login.getOptionalPrivateKey().orNull());
                if (login.shouldAuthenticateSudo()) {
                    out.name("authenticateSudo");
                    out.value(login.shouldAuthenticateSudo());
                }
            } else {
                out.name("identity");
                out.value(credentials.identity);
                out.name("credential");
                out.value(credentials.credential);
            }
            out.endObject();
        }

        @Override
        public Credentials read(JsonReader in) throws IOException {
            LoginCredentials.Builder builder = LoginCredentials.builder();
            String identity = null;
            String credential = null;
            in.beginObject();
            while (in.hasNext()) {
                String name = in.nextName();
                if (name.equals("identity")) {
                    identity = in.nextString();
                    continue;
                }
                if (name.equals("credential")) {
                    credential = in.nextString();
                    continue;
                }
                if (name.equals("user")) {
                    builder.user(in.nextString());
                    continue;
                }
                if (name.equals("password")) {
                    builder.password(in.nextString());
                    continue;
                }
                if (name.equals("privateKey")) {
                    builder.privateKey(in.nextString());
                    continue;
                }
                if (name.equals("authenticateSudo")) {
                    builder.authenticateSudo(in.nextBoolean());
                    continue;
                }
                in.skipValue();
            }
            in.endObject();
            LoginCredentials result = builder.build();
            return result != null ? result : new Credentials(identity, credential);
        }

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            if (!Credentials.class.isAssignableFrom(typeToken.getRawType())) {
                return null;
            }
            return this;
        }
    }

    private static class FileTypeAdapter
    extends TypeAdapter<File> {
        private FileTypeAdapter() {
        }

        @Override
        public void write(JsonWriter out, File file) throws IOException {
            if (file == null) {
                out.nullValue();
            } else {
                out.value(file.getPath());
            }
        }

        @Override
        public File read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return new File(in.nextString());
        }
    }

    @Singleton
    public static class LongDateAdapter
    extends DateAdapter {
        @Override
        public void write(JsonWriter writer, Date value) throws IOException {
            writer.value(value.getTime());
        }

        @Override
        public Date read(JsonReader reader) throws IOException {
            long toParse = reader.nextLong();
            if (toParse == -1L) {
                return null;
            }
            return new Date(toParse);
        }
    }

    @Singleton
    public static class CDateAdapter
    extends DateAdapter {
        private final DateService dateService;

        @Inject
        public CDateAdapter(DateService dateService) {
            this.dateService = dateService;
        }

        @Override
        public void write(JsonWriter writer, Date value) throws IOException {
            writer.value(this.dateService.cDateFormat(value));
        }

        @Override
        public Date read(JsonReader reader) throws IOException {
            return this.dateService.cDateParse(reader.nextString());
        }
    }

    @Singleton
    public static class PropertiesAdapter
    extends TypeAdapter<Properties> {
        private final Provider<Gson> gson;
        private final TypeToken<Map<String, String>> mapType = new TypeToken<Map<String, String>>(){};

        @Inject
        public PropertiesAdapter(Provider<Gson> gson) {
            this.gson = gson;
        }

        @Override
        public void write(JsonWriter out, Properties value) throws IOException {
            ImmutableMap.Builder<String, String> srcMap = ImmutableMap.builder();
            Enumeration<?> propNames = value.propertyNames();
            while (propNames.hasMoreElements()) {
                String propName = (String)propNames.nextElement();
                srcMap.put(propName, value.getProperty(propName));
            }
            this.gson.get().getAdapter(this.mapType).write(out, srcMap.build());
        }

        @Override
        public Properties read(JsonReader in) throws IOException {
            Properties props = new Properties();
            in.beginObject();
            while (in.hasNext()) {
                JsonReaderInternalAccess.INSTANCE.promoteNameToValue(in);
                props.setProperty(in.nextString(), in.nextString());
            }
            in.endObject();
            return props;
        }
    }

    @Singleton
    public static class Iso8601DateAdapter
    extends DateAdapter {
        private final DateService dateService;

        @Inject
        public Iso8601DateAdapter(DateService dateService) {
            this.dateService = dateService;
        }

        @Override
        public void write(JsonWriter writer, Date value) throws IOException {
            writer.value(this.dateService.iso8601DateFormat(value));
        }

        @Override
        public Date read(JsonReader reader) throws IOException {
            return this.parseDate(reader.nextString());
        }

        protected Date parseDate(String toParse) {
            try {
                return this.dateService.iso8601DateParse(toParse);
            }
            catch (RuntimeException e) {
                return this.dateService.iso8601SecondsDateParse(toParse);
            }
        }
    }

    @Singleton
    public static class HexByteArrayAdapter
    extends ByteArrayAdapter {
        @Override
        public void write(JsonWriter writer, byte[] value) throws IOException {
            writer.value(BaseEncoding.base16().lowerCase().encode(value));
        }

        @Override
        public byte[] read(JsonReader reader) throws IOException {
            return BaseEncoding.base16().lowerCase().decode(reader.nextString());
        }
    }

    @Singleton
    public static class HexByteListAdapter
    extends ByteListAdapter {
        @Override
        public void write(JsonWriter writer, List<Byte> value) throws IOException {
            writer.value(BaseEncoding.base16().lowerCase().encode(Bytes.toArray(value)));
        }

        @Override
        public List<Byte> read(JsonReader reader) throws IOException {
            return Bytes.asList(BaseEncoding.base16().lowerCase().decode(reader.nextString()));
        }
    }

    @ImplementedBy(value=HexByteArrayAdapter.class)
    public static abstract class ByteArrayAdapter
    extends TypeAdapter<byte[]> {
    }

    @ImplementedBy(value=HexByteListAdapter.class)
    public static abstract class ByteListAdapter
    extends TypeAdapter<List<Byte>> {
    }

    public static class NullHackJsonBallAdapter
    extends NullHackJsonLiteralAdapter<JsonBall> {
        @Override
        protected JsonBall createJsonLiteralFromRawJson(String json) {
            return new JsonBall(json);
        }
    }

    @ImplementedBy(value=CDateAdapter.class)
    public static abstract class DateAdapter
    extends TypeAdapter<Date> {
    }

    public static class NoExclusions
    implements DefaultExclusionStrategy {
        @Override
        public boolean shouldSkipField(FieldAttributes f) {
            return false;
        }

        @Override
        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }
    }

    @ImplementedBy(value=NoExclusions.class)
    public static interface DefaultExclusionStrategy
    extends ExclusionStrategy {
    }
}

