/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.b2.config;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.inject.Provides;
import org.apache.pulsar.jcloud.shade.com.google.inject.Scopes;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Named;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.b2.B2Api;
import org.jclouds.b2.domain.Authorization;
import org.jclouds.b2.filters.B2RetryHandler;
import org.jclouds.b2.filters.RequestAuthorization;
import org.jclouds.b2.handlers.ParseB2ErrorFromJsonContent;
import org.jclouds.collect.Memoized;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.config.HttpApiModule;
import org.jclouds.rest.suppliers.MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier;

@ConfiguresHttpApi
public final class B2HttpApiModule
extends HttpApiModule<B2Api> {
    @Override
    protected void configure() {
        super.configure();
        this.bind(RequestAuthorization.class).in(Scopes.SINGLETON);
    }

    @Override
    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(ParseB2ErrorFromJsonContent.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(ParseB2ErrorFromJsonContent.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(ParseB2ErrorFromJsonContent.class);
    }

    @Override
    protected void bindRetryHandlers() {
        this.bind(HttpRetryHandler.class).annotatedWith(ServerError.class).to(B2RetryHandler.class);
    }

    @Provides
    @Singleton
    static Supplier<Authorization> provideAuthorizationSupplier(final B2Api b2Api) {
        return new Supplier<Authorization>(){

            @Override
            public Authorization get() {
                return b2Api.getAuthorizationApi().authorizeAccount();
            }
        };
    }

    @Provides
    @Singleton
    @Memoized
    static Supplier<Authorization> provideAuthorizationCache(AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds, Supplier<Authorization> uncached) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, uncached, seconds, TimeUnit.SECONDS);
    }
}

