/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore.functions;

import java.util.TreeSet;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Iterables;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Sets;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.azureblob.blobstore.functions.BlobPropertiesToBlobMetadata;
import org.jclouds.azureblob.domain.ListBlobsResponse;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.blobstore.functions.PrefixToResourceMetadata;

@Singleton
public class ListBlobsResponseToResourceList
implements Function<ListBlobsResponse, PageSet<? extends StorageMetadata>> {
    private final BlobPropertiesToBlobMetadata object2blobMd;
    private final PrefixToResourceMetadata prefix2ResourceMd;
    protected final Function<StorageMetadata, String> indexer = new Function<StorageMetadata, String>(){

        @Override
        public String apply(StorageMetadata from) {
            return from.getName();
        }
    };

    @Inject
    public ListBlobsResponseToResourceList(BlobPropertiesToBlobMetadata object2blobMd, PrefixToResourceMetadata prefix2ResourceMd) {
        this.object2blobMd = object2blobMd;
        this.prefix2ResourceMd = prefix2ResourceMd;
    }

    @Override
    public PageSet<? extends StorageMetadata> apply(ListBlobsResponse from) {
        TreeSet<MutableBlobMetadata> contents = Sets.newTreeSet(Iterables.transform(from, this.object2blobMd));
        for (String prefix : from.getBlobPrefixes()) {
            contents.add((MutableBlobMetadata)this.prefix2ResourceMd.apply(prefix));
        }
        return new PageSetImpl<MutableBlobMetadata>(contents, from.getNextMarker());
    }
}

