/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.functions;

import java.util.Map;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Splitter;
import org.apache.pulsar.jcloud.shade.com.google.common.io.BaseEncoding;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.atmos.domain.FileType;
import org.jclouds.atmos.domain.SystemMetadata;
import org.jclouds.date.DateService;
import org.jclouds.http.HttpResponse;

@Singleton
public class ParseSystemMetadataFromHeaders
implements Function<HttpResponse, SystemMetadata> {
    private final DateService dateService;

    @Inject
    public ParseSystemMetadataFromHeaders(DateService dateService) {
        this.dateService = Preconditions.checkNotNull(dateService, "dateService");
    }

    @Override
    public SystemMetadata apply(HttpResponse from) {
        String[] parts;
        Preconditions.checkNotNull(from, "http response");
        String meta = Preconditions.checkNotNull(from.getFirstHeaderOrNull("x-emc-meta"), "x-emc-meta");
        Map<String, String> metaMap = Splitter.on(", ").withKeyValueSeparator('=').split(meta);
        assert (metaMap.size() >= 12) : String.format("Should be 12 entries in %s", metaMap);
        byte[] md5 = null;
        String wschecksum = from.getFirstHeaderOrNull("x-emc-wschecksum");
        if (wschecksum != null && (parts = wschecksum.split("/"))[0].equalsIgnoreCase("MD5") && parts.length == 3) {
            md5 = BaseEncoding.base16().lowerCase().decode(parts[2]);
        }
        return new SystemMetadata(md5, this.dateService.iso8601SecondsDateParse(Preconditions.checkNotNull(metaMap.get("atime"), "atime")), this.dateService.iso8601SecondsDateParse(Preconditions.checkNotNull(metaMap.get("ctime"), "ctime")), Preconditions.checkNotNull(metaMap.get("gid"), "gid"), this.dateService.iso8601SecondsDateParse(Preconditions.checkNotNull(metaMap.get("itime"), "itime")), this.dateService.iso8601SecondsDateParse(Preconditions.checkNotNull(metaMap.get("mtime"), "mtime")), Integer.parseInt(Preconditions.checkNotNull(metaMap.get("nlink"), "nlink")), Preconditions.checkNotNull(metaMap.get("objectid"), "objectid"), Preconditions.checkNotNull(metaMap.get("objname"), "objname"), Preconditions.checkNotNull(metaMap.get("policyname"), "policyname"), Long.parseLong(Preconditions.checkNotNull(metaMap.get("size"), "size")), FileType.fromValue(Preconditions.checkNotNull(metaMap.get("type"), "type")), Preconditions.checkNotNull(metaMap.get("uid"), "uid"));
    }
}

