/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.blobstore;

import java.util.Set;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Provider;
import org.jclouds.aws.s3.AWSS3Client;
import org.jclouds.aws.s3.blobstore.options.AWSS3PutObjectOptions;
import org.jclouds.aws.s3.blobstore.options.AWSS3PutOptions;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.strategy.internal.FetchBlobMetadata;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.io.PayloadSlicer;
import org.jclouds.s3.blobstore.S3BlobStore;
import org.jclouds.s3.blobstore.functions.BlobToObject;
import org.jclouds.s3.blobstore.functions.BlobToObjectMetadata;
import org.jclouds.s3.blobstore.functions.BucketToResourceList;
import org.jclouds.s3.blobstore.functions.ContainerToBucketListOptions;
import org.jclouds.s3.blobstore.functions.ObjectToBlob;
import org.jclouds.s3.blobstore.functions.ObjectToBlobMetadata;
import org.jclouds.s3.domain.BucketMetadata;
import org.jclouds.s3.domain.ObjectMetadata;

public class AWSS3BlobStore
extends S3BlobStore {
    private final BlobToObject blob2Object;

    @Inject
    AWSS3BlobStore(BlobStoreContext context, BlobUtils blobUtils, Supplier<Location> defaultLocation, @Memoized Supplier<Set<? extends Location>> locations, PayloadSlicer slicer, AWSS3Client sync, Function<Set<BucketMetadata>, PageSet<? extends StorageMetadata>> convertBucketsToStorageMetadata, ContainerToBucketListOptions container2BucketListOptions, BucketToResourceList bucket2ResourceList, ObjectToBlob object2Blob, BlobToHttpGetOptions blob2ObjectGetOptions, BlobToObject blob2Object, BlobToObjectMetadata blob2ObjectMetadata, ObjectToBlobMetadata object2BlobMd, Provider<FetchBlobMetadata> fetchBlobMetadataProvider) {
        super(context, blobUtils, defaultLocation, locations, slicer, sync, convertBucketsToStorageMetadata, container2BucketListOptions, bucket2ResourceList, object2Blob, blob2ObjectGetOptions, blob2Object, blob2ObjectMetadata, object2BlobMd, fetchBlobMetadataProvider);
        this.blob2Object = blob2Object;
    }

    @Override
    public String putBlob(String container, Blob blob, PutOptions options) {
        if (options.isMultipart()) {
            return this.putMultipartBlob(container, blob, options);
        }
        if (options instanceof AWSS3PutOptions && ((AWSS3PutOptions)options).getStorageClass() == ObjectMetadata.StorageClass.REDUCED_REDUNDANCY) {
            return this.putBlobWithReducedRedundancy(container, blob);
        }
        return super.putBlob(container, blob, options);
    }

    private String putBlobWithReducedRedundancy(String container, Blob blob) {
        AWSS3PutObjectOptions options = new AWSS3PutObjectOptions();
        options.storageClass(ObjectMetadata.StorageClass.REDUCED_REDUNDANCY);
        return this.getContext().unwrapApi(AWSS3Client.class).putObject(container, this.blob2Object.apply(blob), options);
    }

    @Override
    public boolean createContainerInLocation(Location location, String container, CreateContainerOptions options) {
        if ((location == null || location.getId().equals("us-standard")) && this.containerExists(container)) {
            return false;
        }
        return super.createContainerInLocation(location, container, options);
    }
}

