/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.catalog.config;

import java.net.URI;
import java.util.NoSuchElementException;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.inject.AbstractModule;
import org.apache.pulsar.jcloud.shade.com.google.inject.Provides;
import org.apache.pulsar.jcloud.shade.com.google.inject.assistedinject.FactoryModuleBuilder;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Named;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.location.Provider;
import org.jclouds.openstack.keystone.catalog.suppliers.RegionIdToAdminURIFromServiceEndpointsForTypeAndVersion;
import org.jclouds.openstack.keystone.catalog.suppliers.RegionIdToAdminURISupplier;
import org.jclouds.openstack.v2_0.services.Identity;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.util.Suppliers2;

public class KeystoneAdminURLModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.install(new FactoryModuleBuilder().implement(RegionIdToAdminURISupplier.class, RegionIdToAdminURIFromServiceEndpointsForTypeAndVersion.class).build(RegionIdToAdminURISupplier.Factory.class));
    }

    @Provides
    @Singleton
    @Identity
    protected final Supplier<URI> provideIdentityAdminUrl(RegionIdToAdminURISupplier.Factory factory, @ApiVersion String version, @Named(value="jclouds.keystone.version") String keystoneVersion, @Provider Supplier<URI> providerURI) {
        Supplier<URI> identityServiceForSpecificVersionInType = Suppliers2.getLastValueInMap(factory.createForApiTypeAndVersion("identityv" + keystoneVersion, version));
        Supplier<URI> identityServiceForVersion = Suppliers2.onThrowable(identityServiceForSpecificVersionInType, NoSuchElementException.class, Suppliers2.getLastValueInMap(factory.createForApiTypeAndVersion("identity", version)));
        Supplier<URI> whenIdentityServiceIsntListedFallbackToProviderURI = Suppliers2.onThrowable(identityServiceForVersion, NoSuchElementException.class, providerURI);
        Supplier<URI> whenIdentityServiceHasNoAdminURLFallbackToProviderURI = Suppliers2.or(whenIdentityServiceIsntListedFallbackToProviderURI, providerURI);
        return whenIdentityServiceHasNoAdminURLFallbackToProviderURI;
    }
}

