/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore.functions;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.azureblob.blobstore.functions.BlobPropertiesToBlobMetadata;
import org.jclouds.azureblob.domain.AzureBlob;
import org.jclouds.blobstore.domain.Blob;

@Singleton
public class AzureBlobToBlob
implements Function<AzureBlob, Blob> {
    private final Blob.Factory blobFactory;
    private final BlobPropertiesToBlobMetadata blobPr2BlobMd;

    @Inject
    AzureBlobToBlob(Blob.Factory blobFactory, BlobPropertiesToBlobMetadata blobPr2BlobMd) {
        this.blobFactory = Preconditions.checkNotNull(blobFactory, "blobFactory");
        this.blobPr2BlobMd = Preconditions.checkNotNull(blobPr2BlobMd, "blobPr2BlobMd");
    }

    @Override
    public Blob apply(AzureBlob from) {
        if (from == null) {
            return null;
        }
        Blob blob = this.blobFactory.create(this.blobPr2BlobMd.apply(from.getProperties()));
        blob.setPayload(Preconditions.checkNotNull(from.getPayload(), "payload: " + from));
        blob.setAllHeaders(from.getAllHeaders());
        return blob;
    }
}

