/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.suppliers.derived;

import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableMap;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.jclouds.location.Region;
import org.jclouds.location.Zone;
import org.jclouds.location.suppliers.ZoneIdToURISupplier;

public final class ZoneIdToURIFromJoinOnRegionIdToURI
implements ZoneIdToURISupplier {
    private final Supplier<Map<String, Supplier<URI>>> regionIdToURIs;
    private final Supplier<Map<String, Supplier<Set<String>>>> regionIdToZoneIds;

    @Inject
    ZoneIdToURIFromJoinOnRegionIdToURI(@Region Supplier<Map<String, Supplier<URI>>> regionIdToURIs, @Zone Supplier<Map<String, Supplier<Set<String>>>> regionIdToZoneIds) {
        this.regionIdToURIs = regionIdToURIs;
        this.regionIdToZoneIds = regionIdToZoneIds;
    }

    @Override
    public Map<String, Supplier<URI>> get() {
        Map<String, Supplier<Set<String>>> regionIdToZoneIds = this.regionIdToZoneIds.get();
        ImmutableMap.Builder<String, Supplier<URI>> builder = ImmutableMap.builder();
        for (Map.Entry<String, Supplier<URI>> regionToURI : this.regionIdToURIs.get().entrySet()) {
            Supplier<Set<String>> zoneIds = regionIdToZoneIds.get(regionToURI.getKey());
            Preconditions.checkState(zoneIds != null, "region %s is not in the configured region to zone mappings: %s", (Object)regionToURI.getKey(), regionIdToZoneIds);
            for (String zone : zoneIds.get()) {
                builder.put(zone, regionToURI.getValue());
            }
        }
        return builder.build();
    }
}

