/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.blobstore.functions;

import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.ListenableFuture;
import org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.pulsar.jcloud.shade.javax.annotation.Resource;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Named;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;
import org.jclouds.s3.blobstore.functions.BucketToResourceMetadata;
import org.jclouds.s3.domain.BucketMetadata;

@Singleton
public class BucketsToStorageMetadata
implements Function<Set<BucketMetadata>, PageSet<? extends StorageMetadata>> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final ListeningExecutorService userExecutor;
    private final BucketToResourceMetadata bucket2ResourceMd;

    @Inject
    public BucketsToStorageMetadata(@Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, BucketToResourceMetadata bucket2ResourceMd) {
        this.userExecutor = Preconditions.checkNotNull(userExecutor, "userExecutor");
        this.bucket2ResourceMd = Preconditions.checkNotNull(bucket2ResourceMd, "bucket2ResourceMd");
    }

    @Override
    public PageSet<? extends StorageMetadata> apply(Set<BucketMetadata> input) {
        Iterable<? extends StorageMetadata> buckets = FutureIterables.transformParallel(input, new Function<BucketMetadata, ListenableFuture<? extends StorageMetadata>>(){

            @Override
            public ListenableFuture<? extends StorageMetadata> apply(final BucketMetadata from) {
                return BucketsToStorageMetadata.this.userExecutor.submit(new Callable<StorageMetadata>(){

                    @Override
                    public StorageMetadata call() throws Exception {
                        return BucketsToStorageMetadata.this.bucket2ResourceMd.apply(from);
                    }

                    public String toString() {
                        return "bucket2ResourceMd.apply(" + from + ")";
                    }
                });
            }
        }, this.userExecutor, null, this.logger, "my buckets");
        return new PageSetImpl<StorageMetadata>(buckets, null);
    }
}

