/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.lifecycle;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Lists;
import org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.Atomics;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;

@Singleton
public class Closer
implements Closeable {
    List<Closeable> methodsToClose = Lists.newArrayList();
    private final AtomicReference<State> state = Atomics.newReference(State.AVAILABLE);

    public void addToClose(Closeable toClose) {
        this.methodsToClose.add(toClose);
    }

    @Override
    public void close() throws IOException {
        if (this.state.compareAndSet(State.AVAILABLE, State.PROCESSING)) {
            Collections.reverse(this.methodsToClose);
            for (Closeable toClose : this.methodsToClose) {
                toClose.close();
            }
            this.state.set(State.DONE);
        }
    }

    public State getState() {
        return this.state.get();
    }

    public static enum State {
        AVAILABLE,
        PROCESSING,
        DONE;

    }
}

