/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.domain;

import java.beans.ConstructorProperties;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.hash.HashCode;
import org.apache.pulsar.jcloud.shade.com.google.gson.annotations.SerializedName;
import org.jclouds.glacier.util.ContentRange;

public class PartMetadata {
    @SerializedName(value="SHA256TreeHash")
    private final HashCode treeHash;
    @SerializedName(value="RangeInBytes")
    private final ContentRange range;

    @ConstructorProperties(value={"SHA256TreeHash", "RangeInBytes"})
    public PartMetadata(String treeHash, String range) {
        this.treeHash = HashCode.fromString(Preconditions.checkNotNull(treeHash, "treeHash"));
        this.range = ContentRange.fromString(Preconditions.checkNotNull(range, "range"));
    }

    public ContentRange getRange() {
        return this.range;
    }

    public HashCode getTreeHash() {
        return this.treeHash;
    }
}

