/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.domain;

import java.beans.ConstructorProperties;
import java.util.Iterator;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Optional;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.gson.annotations.SerializedName;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.glacier.domain.JobMetadata;
import org.jclouds.glacier.options.PaginationOptions;

public class PaginatedJobCollection
extends IterableWithMarker<JobMetadata> {
    @SerializedName(value="JobList")
    private final Iterable<JobMetadata> jobs;
    @SerializedName(value="Marker")
    private final String marker;

    @ConstructorProperties(value={"JobList", "Marker"})
    public PaginatedJobCollection(Iterable<JobMetadata> jobs, String marker) {
        this.jobs = Preconditions.checkNotNull(jobs, "jobs");
        this.marker = marker;
    }

    @Override
    public Iterator<JobMetadata> iterator() {
        return this.jobs.iterator();
    }

    @Override
    public Optional<Object> nextMarker() {
        return Optional.fromNullable(this.marker);
    }

    public PaginationOptions nextPaginationOptions() {
        return (PaginationOptions)PaginationOptions.class.cast(this.nextMarker().get());
    }
}

